package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorUI extends JPanel implements FaxToMailUI<PDFEditorUIModel, PDFEditorUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NEXT_PAGE_BUTTON_ENABLED = "nextPageButton.enabled";
    public static final String BINDING_PAGE_NUMBER_MODEL_TEXT = "pageNumber.modelText";
    public static final String BINDING_PAGE_TOTAL_TEXT = "pageTotal.text";
    public static final String BINDING_PREV_PAGE_BUTTON_ENABLED = "prevPageButton.enabled";
    public static final String BINDING_ZOOM_LABEL_TEXT = "zoomLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(PDFEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JAXXButtonGroup actionGroup;
    protected JButton cancelButton;
    protected JPanel container;
    protected JToggleButton crossButton;
    protected JImagePanel documentPanel;
    protected JToggleButton hLineButton;
    protected final PDFEditorUIHandler handler = createHandler();
    protected JToggleButton highlighterButton;
    protected PDFEditorUIModel model;
    protected JButton nextPageButton;
    protected JToggleButton noteButton;
    protected NumberEditor pageNumber;
    protected JLabel pageTotal;
    protected PDFEditorUI pdfEditorUIPanel = this;
    protected JButton prevPageButton;
    protected JButton printButton;
    protected JButton rotateAntiClockwiseButton;
    protected JButton rotateClockwiseButton;
    protected JToolBar toolbar;
    protected JToggleButton vLineButton;
    protected JButton validateButton;
    protected JButton zoomInButton;
    protected JLabel zoomLabel;
    protected JButton zoomOutButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public PDFEditorUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI() {
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__nextPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModel().incPageIndex();
    }

    public void doActionPerformed__on__prevPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getModel().decPageIndex();
    }

    public void doActionPerformed__on__printButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__rotateAntiClockwiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.rotateAntiClockwise();
    }

    public void doActionPerformed__on__rotateClockwiseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.rotateClockwise();
    }

    public void doActionPerformed__on__zoomInButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoomIn();
    }

    public void doActionPerformed__on__zoomOutButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoomOut();
    }

    public void doMouseClicked__on__documentPanel(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addEditionComponent(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXButtonGroup getActionGroup() {
        return actionGroup;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getContainer() {
        return container;
    }

    public JToggleButton getCrossButton() {
        return crossButton;
    }

    public JImagePanel getDocumentPanel() {
        return documentPanel;
    }

    public JToggleButton getHLineButton() {
        return hLineButton;
    }

    public PDFEditorUIHandler getHandler() {
        return handler;
    }

    public JToggleButton getHighlighterButton() {
        return highlighterButton;
    }

    public PDFEditorUIModel getModel() {
        return model;
    }

    public JButton getNextPageButton() {
        return nextPageButton;
    }

    public JToggleButton getNoteButton() {
        return noteButton;
    }

    public NumberEditor getPageNumber() {
        return pageNumber;
    }

    public JLabel getPageTotal() {
        return pageTotal;
    }

    public JButton getPrevPageButton() {
        return prevPageButton;
    }

    public JButton getPrintButton() {
        return printButton;
    }

    public JButton getRotateAntiClockwiseButton() {
        return rotateAntiClockwiseButton;
    }

    public JButton getRotateClockwiseButton() {
        return rotateClockwiseButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public JToggleButton getVLineButton() {
        return vLineButton;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public JButton getZoomInButton() {
        return zoomInButton;
    }

    public JLabel getZoomLabel() {
        return zoomLabel;
    }

    public JButton getZoomOutButton() {
        return zoomOutButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContainer() {
        if (!allComponentsCreated) {
            return;
        }
        container.add(documentPanel);
    }

    protected void addChildrenToCrossButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; crossButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(crossButton); }
    }

    protected void addChildrenToHLineButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; hLineButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(hLineButton); }
    }

    protected void addChildrenToHighlighterButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; highlighterButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(highlighterButton); }
    }

    protected void addChildrenToNoteButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; noteButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(noteButton); }
    }

    protected void addChildrenToPdfEditorUIPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolbar, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(noteButton);
        toolbar.add(crossButton);
        toolbar.add(hLineButton);
        toolbar.add(vLineButton);
        toolbar.add(highlighterButton);
        toolbar.add($JSeparator0);
        toolbar.add(prevPageButton);
        toolbar.add(pageNumber);
        toolbar.add(pageTotal);
        toolbar.add(nextPageButton);
        toolbar.add(zoomOutButton);
        toolbar.add(zoomLabel);
        toolbar.add(zoomInButton);
        toolbar.add(rotateClockwiseButton);
        toolbar.add(rotateAntiClockwiseButton);
        toolbar.add($JSeparator1);
        toolbar.add(printButton);
    }

    protected void addChildrenToVLineButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = actionGroup; vLineButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(vLineButton); }
    }

    protected void createActionGroup() {
        $objectMap.put("actionGroup", actionGroup = new JAXXButtonGroup());
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.pdfEditor.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.pdfEditor.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createContainer() {
        $objectMap.put("container", container = new JPanel());
        
        container.setName("container");
        container.setLayout(null);
    }

    protected void createCrossButton() {
        $objectMap.put("crossButton", crossButton = new JToggleButton());
        
        crossButton.setName("crossButton");
        { crossButton.putClientProperty("$value", "CROSS");  Object $buttonGroup = crossButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        crossButton.setToolTipText(t("faxtomail.pdfEditor.button.addCross.tip"));
    }

    protected void createDocumentPanel() {
        $objectMap.put("documentPanel", documentPanel = new JImagePanel());
        
        documentPanel.setName("documentPanel");
        documentPanel.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__documentPanel"));
    }

    protected void createHLineButton() {
        $objectMap.put("hLineButton", hLineButton = new JToggleButton());
        
        hLineButton.setName("hLineButton");
        { hLineButton.putClientProperty("$value", "HLINE");  Object $buttonGroup = hLineButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        hLineButton.setToolTipText(t("faxtomail.pdfEditor.button.addHLine.tip"));
    }

    protected PDFEditorUIHandler createHandler() {
        return new PDFEditorUIHandler();
    }

    protected void createHighlighterButton() {
        $objectMap.put("highlighterButton", highlighterButton = new JToggleButton());
        
        highlighterButton.setName("highlighterButton");
        { highlighterButton.putClientProperty("$value", "HIGHLIGHTER");  Object $buttonGroup = highlighterButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        highlighterButton.setToolTipText(t("faxtomail.pdfEditor.button.addHighlighter.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new PDFEditorUIModel());
    }

    protected void createNextPageButton() {
        $objectMap.put("nextPageButton", nextPageButton = new JButton());
        
        nextPageButton.setName("nextPageButton");
        nextPageButton.setToolTipText(t("faxtomail.pdfEditor.button.nextPage"));
        nextPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPageButton"));
    }

    protected void createNoteButton() {
        $objectMap.put("noteButton", noteButton = new JToggleButton());
        
        noteButton.setName("noteButton");
        { noteButton.putClientProperty("$value", "NOTE");  Object $buttonGroup = noteButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        noteButton.setSelected(true);
        noteButton.setToolTipText(t("faxtomail.pdfEditor.button.addNote.tip"));
    }

    protected void createPageNumber() {
        $objectMap.put("pageNumber", pageNumber = new NumberEditor(this));
        
        pageNumber.setName("pageNumber");
        pageNumber.setUseSign(false);
        pageNumber.setAutoPopup(false);
        SwingUtil.setComponentWidth(pageNumber,50);
        pageNumber.setProperty("currentPageIndex");
        pageNumber.setUseFloat(false);
        pageNumber.setShowReset(false);
        pageNumber.setShowPopupButton(false);
    }

    protected void createPageTotal() {
        $objectMap.put("pageTotal", pageTotal = new JLabel());
        
        pageTotal.setName("pageTotal");
    }

    protected void createPrevPageButton() {
        $objectMap.put("prevPageButton", prevPageButton = new JButton());
        
        prevPageButton.setName("prevPageButton");
        prevPageButton.setToolTipText(t("faxtomail.pdfEditor.button.previousPage"));
        prevPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__prevPageButton"));
    }

    protected void createPrintButton() {
        $objectMap.put("printButton", printButton = new JButton());
        
        printButton.setName("printButton");
        printButton.setToolTipText(t("faxtomail.pdfEditor.button.print"));
        printButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printButton"));
    }

    protected void createRotateAntiClockwiseButton() {
        $objectMap.put("rotateAntiClockwiseButton", rotateAntiClockwiseButton = new JButton());
        
        rotateAntiClockwiseButton.setName("rotateAntiClockwiseButton");
        rotateAntiClockwiseButton.setToolTipText(t("faxtomail.pdfEditor.button.rotateAntiClockwise"));
        rotateAntiClockwiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rotateAntiClockwiseButton"));
    }

    protected void createRotateClockwiseButton() {
        $objectMap.put("rotateClockwiseButton", rotateClockwiseButton = new JButton());
        
        rotateClockwiseButton.setName("rotateClockwiseButton");
        rotateClockwiseButton.setToolTipText(t("faxtomail.pdfEditor.button.rotateClockwise"));
        rotateClockwiseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rotateClockwiseButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    protected void createVLineButton() {
        $objectMap.put("vLineButton", vLineButton = new JToggleButton());
        
        vLineButton.setName("vLineButton");
        { vLineButton.putClientProperty("$value", "VLINE");  Object $buttonGroup = vLineButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        vLineButton.setToolTipText(t("faxtomail.pdfEditor.button.addVLine.tip"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.pdfEditor.action.validate"));
        validateButton.setToolTipText(t("faxtomail.pdfEditor.action.validate.tip"));
        validateButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.GenerateAnnotatedAttachmentAction.class);
    }

    protected void createZoomInButton() {
        $objectMap.put("zoomInButton", zoomInButton = new JButton());
        
        zoomInButton.setName("zoomInButton");
        zoomInButton.setToolTipText(t("faxtomail.pdfEditor.button.zoomIn"));
        zoomInButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__zoomInButton"));
    }

    protected void createZoomLabel() {
        $objectMap.put("zoomLabel", zoomLabel = new JLabel());
        
        zoomLabel.setName("zoomLabel");
    }

    protected void createZoomOutButton() {
        $objectMap.put("zoomOutButton", zoomOutButton = new JButton());
        
        zoomOutButton.setName("zoomOutButton");
        zoomOutButton.setToolTipText(t("faxtomail.pdfEditor.button.zoomOut"));
        zoomOutButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__zoomOutButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToPdfEditorUIPanel();
        addChildrenToToolbar();
        addChildrenToNoteButton();
        addChildrenToCrossButton();
        addChildrenToHLineButton();
        addChildrenToVLineButton();
        addChildrenToHighlighterButton();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add(container);
        addChildrenToContainer();
        // inline complete setup of $JPanel1
        $JPanel1.add(cancelButton);
        $JPanel1.add(validateButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 21 property setters
        toolbar.setMargin(new java.awt.Insets(5, 0, 0, 5));
        noteButton.setIcon(SwingUtil.createActionIcon("note"));
        crossButton.setIcon(SwingUtil.createActionIcon("cross"));
        hLineButton.setIcon(SwingUtil.createActionIcon("hline"));
        vLineButton.setIcon(SwingUtil.createActionIcon("vline"));
        highlighterButton.setIcon(SwingUtil.createActionIcon("highlighter"));
        $JSeparator0.setBorder( BorderFactory.createEmptyBorder(0, 5, 0, 5) );
        prevPageButton.setIcon(SwingUtil.createActionIcon("left"));
        pageNumber.setBean( model );
        nextPageButton.setIcon(SwingUtil.createActionIcon("right"));
        zoomOutButton.setIcon(SwingUtil.createActionIcon("zoom-out"));
        zoomInButton.setIcon(SwingUtil.createActionIcon("zoom-in"));
        rotateClockwiseButton.setIcon(SwingUtil.createActionIcon("rotate-clockwise"));
        rotateAntiClockwiseButton.setIcon(SwingUtil.createActionIcon("rotate-anticlockwise"));
        $JSeparator1.setBorder( BorderFactory.createEmptyBorder(0, 5, 0, 5) );
        printButton.setIcon(SwingUtil.createActionIcon("print"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("pdfEditorUIPanel", pdfEditorUIPanel);
        createModel();
        createToolbar();
        createNoteButton();
        createCrossButton();
        createHLineButton();
        createVLineButton();
        createHighlighterButton();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.VERTICAL));
        
        $JSeparator0.setName("$JSeparator0");
        createPrevPageButton();
        createPageNumber();
        createPageTotal();
        createNextPageButton();
        createZoomOutButton();
        createZoomLabel();
        createZoomInButton();
        createRotateClockwiseButton();
        createRotateAntiClockwiseButton();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator(SwingConstants.VERTICAL));
        
        $JSeparator1.setName("$JSeparator1");
        createPrintButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createContainer();
        createDocumentPanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        createActionGroup();
        // inline creation of pdfEditorUIPanel
        setName("pdfEditorUIPanel");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREV_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("currentPageIndex", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    prevPageButton.setEnabled( getModel().getCurrentPageIndex() > 1 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("currentPageIndex", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_NUMBER_MODEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentPageIndex", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pageNumber.setModelText( String.valueOf(model.getCurrentPageIndex()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentPageIndex", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAGE_TOTAL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("pages", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPages() != null) {
                    pageTotal.setText(t( " / " + String.valueOf(model.getPages().length) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("pages", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("currentPageIndex", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("pages", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPages() != null) {
                    nextPageButton.setEnabled( getModel().getCurrentPageIndex() < getModel().getPages().length );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("currentPageIndex", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("pages", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZOOM_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("zoom", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    zoomLabel.setText(t( String.format("%.0f", model.getZoom() * 100) + "%"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("zoom", this);
                }
            }
        });
    }

}