/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.nuiton.i18n.I18n;

public class AddAttachmentAction
extends AbstractFaxToMailAction<AttachmentEditorUIModel, AttachmentEditorUI, AttachmentEditorUIHandler> {
    public AddAttachmentAction(AttachmentEditorUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setAddedByUser(true);
        File file = ((AttachmentEditorUI)this.getUI()).getFile().getSelectedFile();
        if (file != null) {
            try {
                FileInputStream is = new FileInputStream(file);
                FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
                AttachmentFile attachmentFile = serviceContext.getEmailService().getAttachmentFileFromStream((InputStream)is);
                attachmentFile.setFilename(file.getName());
                attachment.setOriginalFile(attachmentFile);
            }
            catch (Exception e) {
                this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.copy.file", (Object[])new Object[0]), (Throwable)e);
            }
            ((AttachmentEditorUIModel)this.getModel()).addAttachment((Attachment)attachment);
            ((AttachmentEditorUI)this.getUI()).getFile().setSelectedFilePath(null);
        }
    }
}

