package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Nov 02 15:27:07 CET 2015")
public abstract class GeneratedConfigurationTopiaDao<E extends Configuration> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Configuration.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.Configuration;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailMaxSizeIn(Collection<Long> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Configuration.PROPERTY_EMAIL_MAX_SIZE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailMaxSizeEquals(long v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Configuration.PROPERTY_EMAIL_MAX_SIZE, v);
        return result;
    }

    @Deprecated
    public E findByEmailMaxSize(long v) {
        return forEmailMaxSizeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEmailMaxSize(long v) {
        return forEmailMaxSizeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSearchDisplayColumnsIn(Collection<List<MailField>> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Configuration.PROPERTY_SEARCH_DISPLAY_COLUMNS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSearchDisplayColumnsEquals(List<MailField> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Configuration.PROPERTY_SEARCH_DISPLAY_COLUMNS, v);
        return result;
    }

    @Deprecated
    public E findBySearchDisplayColumns(List<MailField> v) {
        return forSearchDisplayColumnsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySearchDisplayColumns(List<MailField> v) {
        return forSearchDisplayColumnsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvalidFormDisabledActionsIn(Collection<EnumSet<MailAction>> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Configuration.PROPERTY_INVALID_FORM_DISABLED_ACTIONS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvalidFormDisabledActionsEquals(EnumSet<MailAction> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Configuration.PROPERTY_INVALID_FORM_DISABLED_ACTIONS, v);
        return result;
    }

    @Deprecated
    public E findByInvalidFormDisabledActions(EnumSet<MailAction> v) {
        return forInvalidFormDisabledActionsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInvalidFormDisabledActions(EnumSet<MailAction> v) {
        return forInvalidFormDisabledActionsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExtensionCommandsContains(ExtensionCommand v) {
        return forContains(Configuration.PROPERTY_EXTENSION_COMMANDS, v);
    }

    @Deprecated
    public E findContainsExtensionCommands(ExtensionCommand v) {
        return forExtensionCommandsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsExtensionCommands(ExtensionCommand v) {
        return forExtensionCommandsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forChefsContains(GroupChef v) {
        return forContains(Configuration.PROPERTY_CHEFS, v);
    }

    @Deprecated
    public E findContainsChefs(GroupChef v) {
        return forChefsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsChefs(GroupChef v) {
        return forChefsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getExtensionCommands() != null) {
              tmp.addAll(entity.getExtensionCommands());
           }
        if (entity.getChefs() != null) {
              tmp.addAll(entity.getChefs());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedConfigurationTopiaDao<E extends Configuration>
