package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu May 07 10:55:34 UTC 2015")
public abstract class GeneratedAttachmentFileTopiaDao<E extends AttachmentFile> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) AttachmentFile.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.AttachmentFile;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            AttachmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Attachment.class, AttachmentTopiaDao.class);
            List<Attachment> list = dao
                    .forProperties(Attachment.PROPERTY_ORIGINAL_FILE, entity)
                    .findAll();
            for (Attachment item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getOriginalFile())) {
                    item.setOriginalFile(null);
                }
            
            }
        }

        {
            AttachmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Attachment.class, AttachmentTopiaDao.class);
            List<Attachment> list = dao
                    .forProperties(Attachment.PROPERTY_EDITED_FILE, entity)
                    .findAll();
            for (Attachment item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getEditedFile())) {
                    item.setEditedFile(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String filename, byte[] content) {
        return create(AttachmentFile.PROPERTY_FILENAME, filename, AttachmentFile.PROPERTY_CONTENT, content);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFilenameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentFile.PROPERTY_FILENAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFilenameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentFile.PROPERTY_FILENAME, v);
        return result;
    }

    @Deprecated
    public E findByFilename(String v) {
        return forFilenameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFilename(String v) {
        return forFilenameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentIn(Collection<byte[]> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentFile.PROPERTY_CONTENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentEquals(byte[] v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentFile.PROPERTY_CONTENT, v);
        return result;
    }

    @Deprecated
    public E findByContent(byte[] v) {
        return forContentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByContent(byte[] v) {
        return forContentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRotationIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentFile.PROPERTY_ROTATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRotationEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentFile.PROPERTY_ROTATION, v);
        return result;
    }

    @Deprecated
    public E findByRotation(int v) {
        return forRotationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRotation(int v) {
        return forRotationEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Attachment.class) {
            AttachmentTopiaDao dao =
                topiaDaoSupplier.getDao(Attachment.class, AttachmentTopiaDao.class);
            tmp = dao.forOriginalFileEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Attachment.class) {
            AttachmentTopiaDao dao =
                topiaDaoSupplier.getDao(Attachment.class, AttachmentTopiaDao.class);
            tmp = dao.forEditedFileEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Attachment.class, entity);
        if (!list.isEmpty()) {
            result.put(Attachment.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAttachmentFileTopiaDao<E extends AttachmentFile>
