package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Nov 12 17:08:50 CET 2015")
public abstract class GeneratedHistoryTopiaDao<E extends History> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) History.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.History;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(HistoryType type) {
        return create(History.PROPERTY_TYPE, type);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forModificationDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(History.PROPERTY_MODIFICATION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forModificationDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(History.PROPERTY_MODIFICATION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByModificationDate(Date v) {
        return forModificationDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByModificationDate(Date v) {
        return forModificationDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFieldsJsonIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(History.PROPERTY_FIELDS_JSON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFieldsJsonEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(History.PROPERTY_FIELDS_JSON, v);
        return result;
    }

    @Deprecated
    public E findByFieldsJson(String v) {
        return forFieldsJsonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFieldsJson(String v) {
        return forFieldsJsonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailIn(Collection<Email> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(History.PROPERTY_EMAIL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailEquals(Email v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(History.PROPERTY_EMAIL, v);
        return result;
    }

    @Deprecated
    public E findByEmail(Email v) {
        return forEmailEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEmail(Email v) {
        return forEmailEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxToMailUserIn(Collection<FaxToMailUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(History.PROPERTY_FAX_TO_MAIL_USER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxToMailUserEquals(FaxToMailUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(History.PROPERTY_FAX_TO_MAIL_USER, v);
        return result;
    }

    @Deprecated
    public E findByFaxToMailUser(FaxToMailUser v) {
        return forFaxToMailUserEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFaxToMailUser(FaxToMailUser v) {
        return forFaxToMailUserEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<HistoryType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(History.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(HistoryType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(History.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(HistoryType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(HistoryType v) {
        return forTypeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forHistoryContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedHistoryTopiaDao<E extends History>
