/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.entities;

import com.franciaflex.faxtomail.persistence.entities.AbstractMailFolderTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public class MailFolderTopiaDao
extends AbstractMailFolderTopiaDao<MailFolder> {
    @Override
    public void delete(MailFolder entity) {
        this.topiaJpaSupport.delete((Object)entity);
        entity.notifyDeleted();
        this.topiaFiresSupport.notifyEntityDeleted((TopiaEntity)entity);
    }

    public Collection<MailFolder> getReadableFolders(FaxToMailUser user) {
        return this.getReadableFolders(user, true);
    }

    public Collection<MailFolder> getReadableFolders(FaxToMailUser user, boolean filterArchiveFoldes) {
        String query = this.newFromClause("mf") + " where (:user in elements(mf.readRightUsers) or exists (from mf.readRightGroups g where g in (:groups)))";
        if (filterArchiveFoldes) {
            query = query + " and mf.archiveFolder = false";
        }
        HashMap map = Maps.newHashMap();
        map.put("user", user);
        map.put("groups", user.getUserGroups());
        List<MailFolder> folders = this.findAll(query, map);
        return folders;
    }

    public Collection<MailFolder> getMoveableFolders(FaxToMailUser user) {
        String query = this.newFromClause("mf") + " where (:user in elements(mf.moveRightUsers) or exists (from mf.moveRightGroups g where g in (:groups))) and mf.archiveFolder = false";
        HashMap map = Maps.newHashMap();
        map.put("user", user);
        map.put("groups", user.getUserGroups());
        List<MailFolder> folders = this.findAll(query, map);
        return folders;
    }
}

