/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.entities;

import com.franciaflex.faxtomail.persistence.entities.AbstractEmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EmailTopiaDao
extends AbstractEmailTopiaDao<Email> {
    public List<Email> search(EmailFilter emailFilter) {
        List<Range> gamme;
        List<EtatAttente> etatAttente;
        List<DemandStatus> demandStatus;
        List<Priority> priority;
        List<DemandType> demandType;
        StringBuilder query = new StringBuilder("FROM " + Email.class.getName() + " E");
        query.append(" WHERE 1 = 1");
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (emailFilter.getMinReceptionDate() != null) {
            query.append(" AND E.receptionDate >= :minReceptionDate");
            args.put("minReceptionDate", emailFilter.getMinReceptionDate());
        }
        if (emailFilter.getMaxReceptionDate() != null) {
            query.append(" AND E.receptionDate <= :maxReceptionDate");
            args.put("maxReceptionDate", emailFilter.getMaxReceptionDate());
        }
        if (emailFilter.getTakenBy() != null) {
            query.append(" AND E.takenBy = :takenBy");
            args.put("takenBy", emailFilter.getTakenBy());
        }
        if (emailFilter.getMinModificationDate() != null || emailFilter.getModifiedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :modificationType");
            args.put("modificationType", HistoryType.MODIFICATION);
            if (emailFilter.getMinModificationDate() != null) {
                query.append("   AND H.modificationDate >= :minModificationDate");
                args.put("minModificationDate", emailFilter.getMinModificationDate());
            }
            if (emailFilter.getModifiedBy() != null) {
                query.append("   AND H.faxToMailUser = :modifiedBy");
                args.put("modifiedBy", emailFilter.getModifiedBy());
            }
            query.append(")");
        }
        if (emailFilter.getMaxModificationDate() != null || emailFilter.getModifiedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :modificationType");
            args.put("modificationType", HistoryType.MODIFICATION);
            if (emailFilter.getMaxModificationDate() != null) {
                query.append("   AND H.modificationDate <= :maxModificationDate");
                args.put("maxModificationDate", emailFilter.getMaxModificationDate());
            }
            if (emailFilter.getModifiedBy() != null) {
                query.append("   AND H.faxToMailUser = :modifiedBy");
                args.put("modifiedBy", emailFilter.getModifiedBy());
            }
            query.append(")");
        }
        if (emailFilter.getMinTransferDate() != null || emailFilter.getTransferBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :transmissionType");
            args.put("transmissionType", HistoryType.TRANSMISSION);
            if (emailFilter.getMinTransferDate() != null) {
                query.append("   AND H.modificationDate >= :minTransferDate");
                args.put("minTransferDate", emailFilter.getMinTransferDate());
            }
            if (emailFilter.getTransferBy() != null) {
                query.append("   AND H.faxToMailUser = :transferBy");
                args.put("transferBy", emailFilter.getTransferBy());
            }
            query.append(")");
        }
        if (emailFilter.getMaxTransferDate() != null || emailFilter.getTransferBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :transmissionType");
            args.put("transmissionType", HistoryType.TRANSMISSION);
            if (emailFilter.getMaxTransferDate() != null) {
                query.append("   AND H.modificationDate <= :maxTransferDate");
                args.put("maxTransferDate", emailFilter.getMaxTransferDate());
            }
            if (emailFilter.getTransferBy() != null) {
                query.append("   AND H.faxToMailUser = :transferBy");
                args.put("transferBy", emailFilter.getTransferBy());
            }
            query.append(")");
        }
        if (emailFilter.getMinArchivedDate() != null || emailFilter.getArchivedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :archivedType");
            args.put("archivedType", HistoryType.ARCHIVED);
            if (emailFilter.getMinArchivedDate() != null) {
                query.append("   AND H.modificationDate >= :minArchivedDate");
                args.put("minArchivedDate", emailFilter.getMinArchivedDate());
            }
            if (emailFilter.getArchivedBy() != null) {
                query.append("   AND H.faxToMailUser = :archivedBy");
                args.put("archivedBy", emailFilter.getArchivedBy());
            }
            query.append(")");
        }
        if (emailFilter.getMaxArchivedDate() != null || emailFilter.getArchivedBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :transmissionType");
            args.put("transmissionType", HistoryType.TRANSMISSION);
            if (emailFilter.getMaxArchivedDate() != null) {
                query.append("   AND H.modificationDate <= :maxArchivedDate");
                args.put("maxArchivedDate", emailFilter.getMaxArchivedDate());
            }
            if (emailFilter.getArchivedBy() != null) {
                query.append("   AND H.faxToMailUser = :archivedBy");
                args.put("archivedBy", emailFilter.getArchivedBy());
            }
            query.append(")");
        }
        if (emailFilter.getMinPrintingDate() != null || emailFilter.getPrintingBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :printingType");
            args.put("printingType", HistoryType.PRINTING);
            if (emailFilter.getMinPrintingDate() != null) {
                query.append("   AND H.modificationDate >= :minPrintingDate");
                args.put("minPrintingDate", emailFilter.getMinPrintingDate());
            }
            if (emailFilter.getPrintingBy() != null) {
                query.append("   AND H.faxToMailUser = :printingBy");
                args.put("printingBy", emailFilter.getPrintingBy());
            }
            query.append(")");
        }
        if (emailFilter.getMaxPrintingDate() != null || emailFilter.getPrintingBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :printingType");
            args.put("printingType", HistoryType.PRINTING);
            if (emailFilter.getMaxPrintingDate() != null) {
                query.append("   AND H.modificationDate <= :maxPrintingDate");
                args.put("maxPrintingDate", emailFilter.getMaxPrintingDate());
            }
            if (emailFilter.getPrintingBy() != null) {
                query.append("   AND H.faxToMailUser = :printingBy");
                args.put("printingBy", emailFilter.getPrintingBy());
            }
            query.append(")");
        }
        if (emailFilter.getMinReplyDate() != null || emailFilter.getReplyBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :replyType");
            args.put("replyType", HistoryType.REPLY);
            if (emailFilter.getMinReplyDate() != null) {
                query.append("   AND H.modificationDate >= :minReplyDate");
                args.put("minReplyDate", emailFilter.getMinReplyDate());
            }
            if (emailFilter.getReplyBy() != null) {
                query.append("   AND H.faxToMailUser = :replyBy");
                args.put("replyBy", emailFilter.getReplyBy());
            }
            query.append(")");
        }
        if (emailFilter.getMaxReplyDate() != null || emailFilter.getReplyBy() != null) {
            query.append(" AND EXISTS (FROM " + History.class.getName() + " H WHERE H in elements(E." + "history" + ")");
            query.append("   AND H.type = :replyType");
            args.put("replyType", HistoryType.REPLY);
            if (emailFilter.getMaxReplyDate() != null) {
                query.append("   AND H.modificationDate <= :maxReplyDate");
                args.put("maxReplyDate", emailFilter.getMaxReplyDate());
            }
            if (emailFilter.getReplyBy() != null) {
                query.append("   AND H.faxToMailUser = :replyBy");
                args.put("replyBy", emailFilter.getReplyBy());
            }
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)emailFilter.getSender())) {
            query.append(" AND lower(E.sender) LIKE lower(:sender)");
            args.put("sender", "%" + emailFilter.getSender() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{emailFilter.getClientCode()})) {
            query.append(" AND lower(E.client.code) LIKE lower(:clientCode)");
            args.put("clientCode", "%" + emailFilter.getClientCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)emailFilter.getDemandObject())) {
            query.append(" AND lower(E.object) LIKE lower(:demandObject)");
            args.put("demandObject", "%" + emailFilter.getDemandObject() + "%");
        }
        if (CollectionUtils.isNotEmpty(demandType = emailFilter.getDemandType())) {
            query.append(" AND (E.demandType IN (:demandType)");
            args.put("demandType", demandType);
            if (demandType.contains(null)) {
                query.append(" OR E.demandType IS NULL");
            }
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)emailFilter.getEdiCodeNumber())) {
            query.append(" AND lower(E.ediCodeNumber) LIKE lower(:ediCodeNumber)");
            args.put("ediCodeNumber", "%" + emailFilter.getEdiCodeNumber() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)emailFilter.getProjectReference())) {
            query.append(" AND lower(E.projectReference) LIKE lower(:projectReference)");
            args.put("projectReference", "%" + emailFilter.getProjectReference() + "%");
        }
        if (CollectionUtils.isNotEmpty(priority = emailFilter.getPriority())) {
            query.append(" AND (E.priority IN (:priority)");
            args.put("priority", priority);
            if (priority.contains(null)) {
                query.append(" OR E.priority IS NULL");
            }
            query.append(")");
        }
        if (CollectionUtils.isNotEmpty(demandStatus = emailFilter.getDemandStatus())) {
            query.append(" AND (E.demandStatus IN (:demandStatus)");
            args.put("demandStatus", demandStatus);
            if (demandStatus.contains(null)) {
                query.append(" OR E.demandStatus IS NULL");
            }
            query.append(")");
        }
        if (CollectionUtils.isNotEmpty(etatAttente = emailFilter.getEtatAttente())) {
            query.append(" AND (E.etatAttente IN (:etatAttente)");
            args.put("etatAttente", etatAttente);
            if (etatAttente.contains(null)) {
                query.append(" OR E.etatAttente IS NULL");
            }
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)emailFilter.getMessage())) {
            query.append(" AND lower(E.comment) LIKE lower(:message)");
            args.put("message", "%" + emailFilter.getMessage() + "%");
        }
        if (CollectionUtils.isNotEmpty(gamme = emailFilter.getGamme())) {
            query.append(" AND ((EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append("   AND RR.range IN (:gamme))");
            args.put("gamme", gamme);
            if (gamme.contains(null)) {
                query.append(" OR NOT EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + "))");
            }
            query.append("))");
        }
        if (StringUtils.isNotBlank((CharSequence)emailFilter.getLocalReference())) {
            query.append(" AND (EXISTS (FROM " + RangeRow.class.getName() + " RR WHERE RR in elements(E." + "rangeRow" + ")");
            query.append("   AND lower(RR.commandNumber) LIKE lower(:localReference))");
            query.append(" OR lower(E.companyReference) LIKE lower(:localReference)");
            args.put("localReference", "%" + emailFilter.getLocalReference() + "%");
            query.append(")");
        }
        return this.findAll(query.toString(), args);
    }

    public Map<String, Long> getMailCountByFolder() {
        String query = "SELECT mailFolder.topiaId, count(*) FROM " + Email.class.getName() + " group by mailFolder.topiaId";
        HashMap<String, Long> result = new HashMap<String, Long>();
        List queryResuts = this.findAll(query);
        for (Object[] queryResut : queryResuts) {
            String mailFolder = (String)queryResut[0];
            Long count = (Long)queryResut[1];
            result.put(mailFolder, count);
        }
        return result;
    }
}

