package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed Jun 11 16:38:33 CEST 2014")
public abstract class HistoryAbstract extends AbstractTopiaEntity implements History {

    /**
     * Nom de l'attribut en BD : modificationDate
     */
    protected Date modificationDate;

    /**
     * Nom de l'attribut en BD : fields
     */
    protected Collection<String> fields;

    /**
     * Nom de l'attribut en BD : faxToMailUser
     */
    protected FaxToMailUser faxToMailUser;

    /**
     * Nom de l'attribut en BD : type
     */
    protected HistoryType type;

    private static final long serialVersionUID = 7365692394691573557L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_MODIFICATION_DATE, Date.class, modificationDate);
        visitor.visit(this, PROPERTY_FIELDS, Collection.class, String.class, fields);
        visitor.visit(this, PROPERTY_FAX_TO_MAIL_USER, FaxToMailUser.class, faxToMailUser);
        visitor.visit(this, PROPERTY_TYPE, HistoryType.class, type);
        visitor.end(this);
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        Date oldValue = this.modificationDate;
        fireOnPreWrite(PROPERTY_MODIFICATION_DATE, oldValue, modificationDate);
        this.modificationDate = modificationDate;
        fireOnPostWrite(PROPERTY_MODIFICATION_DATE, oldValue, modificationDate);
    }

    @Override
    public Date getModificationDate() {
        fireOnPreRead(PROPERTY_MODIFICATION_DATE, modificationDate);
        Date result = this.modificationDate;
        fireOnPostRead(PROPERTY_MODIFICATION_DATE, modificationDate);
        return result;
    }

    @Override
    public void addFields(String fields) {
        fireOnPreWrite(PROPERTY_FIELDS, null, fields);
        if (this.fields == null) {
            this.fields = new LinkedList<String>();
        }

        this.fields.add(fields);
        fireOnPostWrite(PROPERTY_FIELDS, this.fields.size(), null, fields);
    }

    @Override
    public void addAllFields(Collection<String> fields) {
        if (fields == null) {
            return;
        }
        for (String item : fields) {
            addFields(item);
        }
    }

    @Override
    public void setFields(Collection<String> fields) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.fields != null ? new LinkedList<String>(this.fields) : null;
        fireOnPreWrite(PROPERTY_FIELDS, oldValue, fields);
        this.fields = fields;
        fireOnPostWrite(PROPERTY_FIELDS, oldValue, fields);
    }

    @Override
    public void removeFields(String fields) {
        fireOnPreWrite(PROPERTY_FIELDS, fields, null);
        if (this.fields == null || !this.fields.remove(fields)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_FIELDS, this.fields.size() + 1, fields, null);
    }

    @Override
    public void clearFields() {
        if (this.fields == null) {
            return;
        }
        Collection<String> oldValue = new LinkedList<String>(this.fields);
        fireOnPreWrite(PROPERTY_FIELDS, oldValue, this.fields);
        this.fields.clear();
        fireOnPostWrite(PROPERTY_FIELDS, oldValue, this.fields);
    }

    @Override
    public Collection<String> getFields() {
        return fields;
    }

    @Override
    public int sizeFields() {
        if (fields == null) {
            return 0;
        }
        return fields.size();
    }

    @Override
    public boolean isFieldsEmpty() {
        int size = sizeFields();
        return size == 0;
    }

    @Override
    public boolean isFieldsNotEmpty() {
        boolean empty = isFieldsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsFields(String fields) {
        boolean contains = this.fields !=null && this.fields.contains(fields);
        return contains;
    }

    @Override
    public void setFaxToMailUser(FaxToMailUser faxToMailUser) {
        FaxToMailUser oldValue = this.faxToMailUser;
        fireOnPreWrite(PROPERTY_FAX_TO_MAIL_USER, oldValue, faxToMailUser);
        this.faxToMailUser = faxToMailUser;
        fireOnPostWrite(PROPERTY_FAX_TO_MAIL_USER, oldValue, faxToMailUser);
    }

    @Override
    public FaxToMailUser getFaxToMailUser() {
        fireOnPreRead(PROPERTY_FAX_TO_MAIL_USER, faxToMailUser);
        FaxToMailUser result = this.faxToMailUser;
        fireOnPostRead(PROPERTY_FAX_TO_MAIL_USER, faxToMailUser);
        return result;
    }

    @Override
    public void setType(HistoryType type) {
        HistoryType oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public HistoryType getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        HistoryType result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

} //HistoryAbstract
