package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Jun 10 11:30:03 CEST 2014")
public abstract class GroupChefAbstract extends AbstractTopiaEntity implements GroupChef {

    /**
     * Nom de l'attribut en BD : managedUsers
     */
    protected Collection<FaxToMailUser> managedUsers;

    /**
     * Nom de l'attribut en BD : managedGroups
     */
    protected Collection<FaxToMailUserGroup> managedGroups;

    /**
     * Nom de l'attribut en BD : userGroup
     */
    protected FaxToMailUserGroup userGroup;

    private static final long serialVersionUID = 7089336744170119737L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_MANAGED_USERS, Collection.class, FaxToMailUser.class, managedUsers);
        visitor.visit(this, PROPERTY_MANAGED_GROUPS, Collection.class, FaxToMailUserGroup.class, managedGroups);
        visitor.visit(this, PROPERTY_USER_GROUP, FaxToMailUserGroup.class, userGroup);
        visitor.end(this);
    }

    @Override
    public void addManagedUsers(FaxToMailUser managedUsers) {
        fireOnPreWrite(PROPERTY_MANAGED_USERS, null, managedUsers);
        if (this.managedUsers == null) {
            this.managedUsers = new LinkedList<FaxToMailUser>();
        }

        this.managedUsers.add(managedUsers);
        fireOnPostWrite(PROPERTY_MANAGED_USERS, this.managedUsers.size(), null, managedUsers);
    }

    @Override
    public void addAllManagedUsers(Collection<FaxToMailUser> managedUsers) {
        if (managedUsers == null) {
            return;
        }
        for (FaxToMailUser item : managedUsers) {
            addManagedUsers(item);
        }
    }

    @Override
    public void setManagedUsers(Collection<FaxToMailUser> managedUsers) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUser> oldValue = this.managedUsers != null ? new LinkedList<FaxToMailUser>(this.managedUsers) : null;
        fireOnPreWrite(PROPERTY_MANAGED_USERS, oldValue, managedUsers);
        this.managedUsers = managedUsers;
        fireOnPostWrite(PROPERTY_MANAGED_USERS, oldValue, managedUsers);
    }

    @Override
    public void removeManagedUsers(FaxToMailUser managedUsers) {
        fireOnPreWrite(PROPERTY_MANAGED_USERS, managedUsers, null);
        if (this.managedUsers == null || !this.managedUsers.remove(managedUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_MANAGED_USERS, this.managedUsers.size() + 1, managedUsers, null);
    }

    @Override
    public void clearManagedUsers() {
        if (this.managedUsers == null) {
            return;
        }
        Collection<FaxToMailUser> oldValue = new LinkedList<FaxToMailUser>(this.managedUsers);
        fireOnPreWrite(PROPERTY_MANAGED_USERS, oldValue, this.managedUsers);
        this.managedUsers.clear();
        fireOnPostWrite(PROPERTY_MANAGED_USERS, oldValue, this.managedUsers);
    }

    @Override
    public Collection<FaxToMailUser> getManagedUsers() {
        return managedUsers;
    }

    @Override
    public FaxToMailUser getManagedUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(managedUsers, topiaId);
    }

    @Override
    public Collection<String> getManagedUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getManagedUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeManagedUsers() {
        if (managedUsers == null) {
            return 0;
        }
        return managedUsers.size();
    }

    @Override
    public boolean isManagedUsersEmpty() {
        int size = sizeManagedUsers();
        return size == 0;
    }

    @Override
    public boolean isManagedUsersNotEmpty() {
        boolean empty = isManagedUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsManagedUsers(FaxToMailUser managedUsers) {
        boolean contains = this.managedUsers !=null && this.managedUsers.contains(managedUsers);
        return contains;
    }

    @Override
    public void addManagedGroups(FaxToMailUserGroup managedGroups) {
        fireOnPreWrite(PROPERTY_MANAGED_GROUPS, null, managedGroups);
        if (this.managedGroups == null) {
            this.managedGroups = new LinkedList<FaxToMailUserGroup>();
        }

        this.managedGroups.add(managedGroups);
        fireOnPostWrite(PROPERTY_MANAGED_GROUPS, this.managedGroups.size(), null, managedGroups);
    }

    @Override
    public void addAllManagedGroups(Collection<FaxToMailUserGroup> managedGroups) {
        if (managedGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : managedGroups) {
            addManagedGroups(item);
        }
    }

    @Override
    public void setManagedGroups(Collection<FaxToMailUserGroup> managedGroups) {
        // Copy elements to keep data for fire with new reference
        Collection<FaxToMailUserGroup> oldValue = this.managedGroups != null ? new LinkedList<FaxToMailUserGroup>(this.managedGroups) : null;
        fireOnPreWrite(PROPERTY_MANAGED_GROUPS, oldValue, managedGroups);
        this.managedGroups = managedGroups;
        fireOnPostWrite(PROPERTY_MANAGED_GROUPS, oldValue, managedGroups);
    }

    @Override
    public void removeManagedGroups(FaxToMailUserGroup managedGroups) {
        fireOnPreWrite(PROPERTY_MANAGED_GROUPS, managedGroups, null);
        if (this.managedGroups == null || !this.managedGroups.remove(managedGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_MANAGED_GROUPS, this.managedGroups.size() + 1, managedGroups, null);
    }

    @Override
    public void clearManagedGroups() {
        if (this.managedGroups == null) {
            return;
        }
        Collection<FaxToMailUserGroup> oldValue = new LinkedList<FaxToMailUserGroup>(this.managedGroups);
        fireOnPreWrite(PROPERTY_MANAGED_GROUPS, oldValue, this.managedGroups);
        this.managedGroups.clear();
        fireOnPostWrite(PROPERTY_MANAGED_GROUPS, oldValue, this.managedGroups);
    }

    @Override
    public Collection<FaxToMailUserGroup> getManagedGroups() {
        return managedGroups;
    }

    @Override
    public FaxToMailUserGroup getManagedGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(managedGroups, topiaId);
    }

    @Override
    public Collection<String> getManagedGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getManagedGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeManagedGroups() {
        if (managedGroups == null) {
            return 0;
        }
        return managedGroups.size();
    }

    @Override
    public boolean isManagedGroupsEmpty() {
        int size = sizeManagedGroups();
        return size == 0;
    }

    @Override
    public boolean isManagedGroupsNotEmpty() {
        boolean empty = isManagedGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsManagedGroups(FaxToMailUserGroup managedGroups) {
        boolean contains = this.managedGroups !=null && this.managedGroups.contains(managedGroups);
        return contains;
    }

    @Override
    public void setUserGroup(FaxToMailUserGroup userGroup) {
        FaxToMailUserGroup oldValue = this.userGroup;
        fireOnPreWrite(PROPERTY_USER_GROUP, oldValue, userGroup);
        this.userGroup = userGroup;
        fireOnPostWrite(PROPERTY_USER_GROUP, oldValue, userGroup);
    }

    @Override
    public FaxToMailUserGroup getUserGroup() {
        fireOnPreRead(PROPERTY_USER_GROUP, userGroup);
        FaxToMailUserGroup result = this.userGroup;
        fireOnPostRead(PROPERTY_USER_GROUP, userGroup);
        return result;
    }

} //GroupChefAbstract
