package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;

@Generated(value = "org.nuiton.topia.templates.EntityEnumTransformer", date = "Tue Jun 10 11:30:04 CEST 2014")

public enum FaxToMailEntityEnum implements TopiaEntityEnum {
    Attachment(Attachment.class, new String[]{"originalFile"}),
    AttachmentFile(AttachmentFile.class, new String[]{"filename", "content"}),
    Client(Client.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Configuration(Configuration.class, ArrayUtils.EMPTY_STRING_ARRAY),
    DemandType(DemandType.class, new String[]{"label"}, "label"),
    EdiReturn(EdiReturn.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Email(Email.class, new String[]{"mailFolder"}),
    EmailAccount(EmailAccount.class, new String[]{"host", "login", "protocol"}, "host", "login", "protocol"),
    EmailGroup(EmailGroup.class, ArrayUtils.EMPTY_STRING_ARRAY),
    EtatAttente(EtatAttente.class, new String[]{"label"}, "label"),
    ExtensionCommand(ExtensionCommand.class, new String[]{"extension"}, "extension"),
    FaxToMailUser(FaxToMailUser.class, new String[]{"login"}, "login"),
    FaxToMailUserGroup(FaxToMailUserGroup.class, new String[]{"name"}, "name"),
    GroupChef(GroupChef.class, new String[]{"userGroup"}),
    History(History.class, new String[]{"type"}),
    MailFilter(MailFilter.class, new String[]{"expression", "mailFolder"}, "expression"),
    MailFolder(MailFolder.class, new String[]{"name"}, "name", "parent"),
    NewClient(NewClient.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Priority(Priority.class, new String[]{"label"}, "label"),
    Range(Range.class, new String[]{"label"}, "label"),
    RangeRow(RangeRow.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Reply(Reply.class, ArrayUtils.EMPTY_STRING_ARRAY);

    /**
     * The contract of the entity.
     */
    protected Class<? extends TopiaEntity> contract;

    /**
     * The fully qualified name of the implementation of the entity.
     */
    protected String implementationFQN;

    /**
     * The implementation class of the entity (will be lazy computed at runtime).
     */
    protected Class<? extends TopiaEntity> implementation;

    /**
     * The array of property involved in the natural key of the entity.
     */
    protected String[] naturalIds;

    /**
     * The array of not null properties of the entity.
     */
    protected String[] notNulls;

    FaxToMailEntityEnum(Class<? extends TopiaEntity> contract, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
    }

    @Override
    public Class<? extends TopiaEntity> getContract() {
        return contract;
    }

    @Override
    public String[] getNaturalIds() {
        return naturalIds;
    }

    @Override
    public boolean isUseNaturalIds() {
        return naturalIds.length > 0;
    }

    @Override
    public String[] getNotNulls() {
        return notNulls;
    }

    @Override
    public boolean isUseNotNulls() {
        return notNulls.length > 0;
    }

    @Override
    public String getImplementationFQN() {
        return implementationFQN;
    }

    @Override
    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }

    @Override
    public boolean accept(Class<? extends TopiaEntity> klass) {
        FaxToMailEntityEnum constant = valueOf(klass);
        boolean result = constant.getContract() == contract;
        return result;
    }

    @Override
    public Class<? extends TopiaEntity> getImplementation() {
        if (implementation == null) {
            try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
    }

    public static FaxToMailEntityEnum valueOf(TopiaEntity entity) {
        return valueOf(entity.getClass());
    }

    public static FaxToMailEntityEnum valueOf(Class<?> klass) {
        if (klass.isInterface()) {
            return valueOf(klass.getSimpleName());
        }
        for (FaxToMailEntityEnum entityEnum : FaxToMailEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(FaxToMailEntityEnum.values()));
    }

    public static FaxToMailEntityEnum[] getContracts() {
        FaxToMailEntityEnum[] result = values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        FaxToMailEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        FaxToMailEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        FaxToMailEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getImplementation();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        FaxToMailEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }

} //FaxToMailEntityEnum
