/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.TypeHintContext;

public final class InboundContext {
    private LinkedList contexts = new LinkedList();
    private int paramCount = 0;
    private final Map variables = new HashMap();
    private final Map converted = new HashMap();

    public void pushContext(TypeHintContext context) {
        this.contexts.addFirst(context);
    }

    public void popContext() {
        this.contexts.removeFirst();
    }

    public TypeHintContext getCurrentTypeHintContext() {
        return (TypeHintContext)this.contexts.getFirst();
    }

    public void createInboundVariable(int callNum, String key, String type, String value) {
        int i;
        InboundVariable cte = new InboundVariable(this, type, value);
        this.variables.put(key, cte);
        String paramPrefix = "c" + callNum + "-" + "param";
        if (key.startsWith(paramPrefix) && (i = Integer.parseInt(key.substring(paramPrefix.length())) + 1) > this.paramCount) {
            this.paramCount = i;
        }
    }

    public InboundVariable getInboundVariable(String name) {
        return (InboundVariable)this.variables.get(name);
    }

    public void clearConverted() {
        this.converted.clear();
    }

    public void addConverted(InboundVariable iv, Object bean) {
        this.converted.put(iv, bean);
    }

    public Object getConverted(InboundVariable iv) {
        return this.converted.get(iv);
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public int getParameterCount(int callNum) {
        int count = 0;
        String prefix = "c" + callNum + "-" + "param";
        Iterator it = this.variables.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(prefix)) continue;
            ++count;
        }
        return count;
    }

    public InboundVariable getParameter(int callNum, int index) {
        String key = "c" + callNum + "-" + "param" + index;
        return (InboundVariable)this.variables.get(key);
    }

    public Iterator getInboundVariableNames() {
        return this.variables.keySet().iterator();
    }
}

