/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SwitchoverBlueGreenDeploymentRequest extends RdsRequest implements
        ToCopyableBuilder<SwitchoverBlueGreenDeploymentRequest.Builder, SwitchoverBlueGreenDeploymentRequest> {
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BlueGreenDeploymentIdentifier")
            .getter(getter(SwitchoverBlueGreenDeploymentRequest::blueGreenDeploymentIdentifier))
            .setter(setter(Builder::blueGreenDeploymentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentIdentifier")
                    .build()).build();

    private static final SdkField<Integer> SWITCHOVER_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SwitchoverTimeout").getter(getter(SwitchoverBlueGreenDeploymentRequest::switchoverTimeout))
            .setter(setter(Builder::switchoverTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SwitchoverTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD, SWITCHOVER_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String blueGreenDeploymentIdentifier;

    private final Integer switchoverTimeout;

    private SwitchoverBlueGreenDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.blueGreenDeploymentIdentifier = builder.blueGreenDeploymentIdentifier;
        this.switchoverTimeout = builder.switchoverTimeout;
    }

    /**
     * <p>
     * The resource ID of the blue/green deployment.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match an existing blue/green deployment resource ID.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The resource ID of the blue/green deployment.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match an existing blue/green deployment resource ID.
     *         </p>
     *         </li>
     */
    public final String blueGreenDeploymentIdentifier() {
        return blueGreenDeploymentIdentifier;
    }

    /**
     * <p>
     * The amount of time, in seconds, for the switchover to complete.
     * </p>
     * <p>
     * Default: 300
     * </p>
     * <p>
     * If the switchover takes longer than the specified duration, then any changes are rolled back, and no changes are
     * made to the environments.
     * </p>
     * 
     * @return The amount of time, in seconds, for the switchover to complete.</p>
     *         <p>
     *         Default: 300
     *         </p>
     *         <p>
     *         If the switchover takes longer than the specified duration, then any changes are rolled back, and no
     *         changes are made to the environments.
     */
    public final Integer switchoverTimeout() {
        return switchoverTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(switchoverTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwitchoverBlueGreenDeploymentRequest)) {
            return false;
        }
        SwitchoverBlueGreenDeploymentRequest other = (SwitchoverBlueGreenDeploymentRequest) obj;
        return Objects.equals(blueGreenDeploymentIdentifier(), other.blueGreenDeploymentIdentifier())
                && Objects.equals(switchoverTimeout(), other.switchoverTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SwitchoverBlueGreenDeploymentRequest")
                .add("BlueGreenDeploymentIdentifier", blueGreenDeploymentIdentifier())
                .add("SwitchoverTimeout", switchoverTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenDeploymentIdentifier":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentIdentifier()));
        case "SwitchoverTimeout":
            return Optional.ofNullable(clazz.cast(switchoverTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlueGreenDeploymentIdentifier", BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD);
        map.put("SwitchoverTimeout", SWITCHOVER_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SwitchoverBlueGreenDeploymentRequest, T> g) {
        return obj -> g.apply((SwitchoverBlueGreenDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SwitchoverBlueGreenDeploymentRequest> {
        /**
         * <p>
         * The resource ID of the blue/green deployment.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match an existing blue/green deployment resource ID.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blueGreenDeploymentIdentifier
         *        The resource ID of the blue/green deployment.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match an existing blue/green deployment resource ID.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier);

        /**
         * <p>
         * The amount of time, in seconds, for the switchover to complete.
         * </p>
         * <p>
         * Default: 300
         * </p>
         * <p>
         * If the switchover takes longer than the specified duration, then any changes are rolled back, and no changes
         * are made to the environments.
         * </p>
         * 
         * @param switchoverTimeout
         *        The amount of time, in seconds, for the switchover to complete.</p>
         *        <p>
         *        Default: 300
         *        </p>
         *        <p>
         *        If the switchover takes longer than the specified duration, then any changes are rolled back, and no
         *        changes are made to the environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder switchoverTimeout(Integer switchoverTimeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String blueGreenDeploymentIdentifier;

        private Integer switchoverTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(SwitchoverBlueGreenDeploymentRequest model) {
            super(model);
            blueGreenDeploymentIdentifier(model.blueGreenDeploymentIdentifier);
            switchoverTimeout(model.switchoverTimeout);
        }

        public final String getBlueGreenDeploymentIdentifier() {
            return blueGreenDeploymentIdentifier;
        }

        public final void setBlueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
        }

        @Override
        public final Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
            return this;
        }

        public final Integer getSwitchoverTimeout() {
            return switchoverTimeout;
        }

        public final void setSwitchoverTimeout(Integer switchoverTimeout) {
            this.switchoverTimeout = switchoverTimeout;
        }

        @Override
        public final Builder switchoverTimeout(Integer switchoverTimeout) {
            this.switchoverTimeout = switchoverTimeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SwitchoverBlueGreenDeploymentRequest build() {
            return new SwitchoverBlueGreenDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
