/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommended actions to apply to resolve the issues associated with your DB instances, DB clusters, and DB
 * parameter groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendedAction implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendedAction.Builder, RecommendedAction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(RecommendedAction::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(RecommendedAction::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RecommendedAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(RecommendedAction::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<List<RecommendedActionParameter>> PARAMETERS_FIELD = SdkField
            .<List<RecommendedActionParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(RecommendedAction::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendedActionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendedActionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> APPLY_MODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplyModes")
            .getter(getter(RecommendedAction::applyModes))
            .setter(setter(Builder::applyModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RecommendedAction::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<IssueDetails> ISSUE_DETAILS_FIELD = SdkField.<IssueDetails> builder(MarshallingType.SDK_POJO)
            .memberName("IssueDetails").getter(getter(RecommendedAction::issueDetails)).setter(setter(Builder::issueDetails))
            .constructor(IssueDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueDetails").build()).build();

    private static final SdkField<List<ContextAttribute>> CONTEXT_ATTRIBUTES_FIELD = SdkField
            .<List<ContextAttribute>> builder(MarshallingType.LIST)
            .memberName("ContextAttributes")
            .getter(getter(RecommendedAction::contextAttributes))
            .setter(setter(Builder::contextAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContextAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContextAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, TITLE_FIELD,
            DESCRIPTION_FIELD, OPERATION_FIELD, PARAMETERS_FIELD, APPLY_MODES_FIELD, STATUS_FIELD, ISSUE_DETAILS_FIELD,
            CONTEXT_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String title;

    private final String description;

    private final String operation;

    private final List<RecommendedActionParameter> parameters;

    private final List<String> applyModes;

    private final String status;

    private final IssueDetails issueDetails;

    private final List<ContextAttribute> contextAttributes;

    private RecommendedAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.title = builder.title;
        this.description = builder.description;
        this.operation = builder.operation;
        this.parameters = builder.parameters;
        this.applyModes = builder.applyModes;
        this.status = builder.status;
        this.issueDetails = builder.issueDetails;
        this.contextAttributes = builder.contextAttributes;
    }

    /**
     * <p>
     * The unique identifier of the recommended action.
     * </p>
     * 
     * @return The unique identifier of the recommended action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * A short description to summarize the action. The description might contain markdown.
     * </p>
     * 
     * @return A short description to summarize the action. The description might contain markdown.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A detailed description of the action. The description might contain markdown.
     * </p>
     * 
     * @return A detailed description of the action. The description might contain markdown.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An API operation for the action.
     * </p>
     * 
     * @return An API operation for the action.
     */
    public final String operation() {
        return operation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters for the API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the API operation.
     */
    public final List<RecommendedActionParameter> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplyModes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApplyModes() {
        return applyModes != null && !(applyModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The methods to apply the recommended action.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>manual</code> - The action requires you to resolve the recommendation manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>immediately</code> - The action is applied immediately.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplyModes} method.
     * </p>
     * 
     * @return The methods to apply the recommended action.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>manual</code> - The action requires you to resolve the recommendation manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>immediately</code> - The action is applied immediately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.
     *         </p>
     *         </li>
     */
    public final List<String> applyModes() {
        return applyModes;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ready</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>applied</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scheduled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolved</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the action.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ready</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>applied</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scheduled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolved</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The details of the issue.
     * </p>
     * 
     * @return The details of the issue.
     */
    public final IssueDetails issueDetails() {
        return issueDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContextAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContextAttributes() {
        return contextAttributes != null && !(contextAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supporting attributes to explain the recommended action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContextAttributes} method.
     * </p>
     * 
     * @return The supporting attributes to explain the recommended action.
     */
    public final List<ContextAttribute> contextAttributes() {
        return contextAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasApplyModes() ? applyModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(issueDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasContextAttributes() ? contextAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedAction)) {
            return false;
        }
        RecommendedAction other = (RecommendedAction) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(operation(), other.operation())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasApplyModes() == other.hasApplyModes() && Objects.equals(applyModes(), other.applyModes())
                && Objects.equals(status(), other.status()) && Objects.equals(issueDetails(), other.issueDetails())
                && hasContextAttributes() == other.hasContextAttributes()
                && Objects.equals(contextAttributes(), other.contextAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendedAction").add("ActionId", actionId()).add("Title", title())
                .add("Description", description()).add("Operation", operation())
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("ApplyModes", hasApplyModes() ? applyModes() : null).add("Status", status())
                .add("IssueDetails", issueDetails())
                .add("ContextAttributes", hasContextAttributes() ? contextAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ApplyModes":
            return Optional.ofNullable(clazz.cast(applyModes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "IssueDetails":
            return Optional.ofNullable(clazz.cast(issueDetails()));
        case "ContextAttributes":
            return Optional.ofNullable(clazz.cast(contextAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionId", ACTION_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ApplyModes", APPLY_MODES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IssueDetails", ISSUE_DETAILS_FIELD);
        map.put("ContextAttributes", CONTEXT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendedAction, T> g) {
        return obj -> g.apply((RecommendedAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendedAction> {
        /**
         * <p>
         * The unique identifier of the recommended action.
         * </p>
         * 
         * @param actionId
         *        The unique identifier of the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * A short description to summarize the action. The description might contain markdown.
         * </p>
         * 
         * @param title
         *        A short description to summarize the action. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A detailed description of the action. The description might contain markdown.
         * </p>
         * 
         * @param description
         *        A detailed description of the action. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An API operation for the action.
         * </p>
         * 
         * @param operation
         *        An API operation for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The parameters for the API operation.
         * </p>
         * 
         * @param parameters
         *        The parameters for the API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<RecommendedActionParameter> parameters);

        /**
         * <p>
         * The parameters for the API operation.
         * </p>
         * 
         * @param parameters
         *        The parameters for the API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(RecommendedActionParameter... parameters);

        /**
         * <p>
         * The parameters for the API operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.RecommendedActionParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rds.model.RecommendedActionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.RecommendedActionParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<RecommendedActionParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.RecommendedActionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<RecommendedActionParameter>)
         */
        Builder parameters(Consumer<RecommendedActionParameter.Builder>... parameters);

        /**
         * <p>
         * The methods to apply the recommended action.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>manual</code> - The action requires you to resolve the recommendation manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>immediately</code> - The action is applied immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applyModes
         *        The methods to apply the recommended action.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>manual</code> - The action requires you to resolve the recommendation manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>immediately</code> - The action is applied immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyModes(Collection<String> applyModes);

        /**
         * <p>
         * The methods to apply the recommended action.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>manual</code> - The action requires you to resolve the recommendation manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>immediately</code> - The action is applied immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param applyModes
         *        The methods to apply the recommended action.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>manual</code> - The action requires you to resolve the recommendation manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>immediately</code> - The action is applied immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyModes(String... applyModes);

        /**
         * <p>
         * The status of the action.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ready</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>applied</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scheduled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolved</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the action.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ready</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>applied</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scheduled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolved</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The details of the issue.
         * </p>
         * 
         * @param issueDetails
         *        The details of the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueDetails(IssueDetails issueDetails);

        /**
         * <p>
         * The details of the issue.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssueDetails.Builder} avoiding the need
         * to create one manually via {@link IssueDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IssueDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #issueDetails(IssueDetails)}.
         * 
         * @param issueDetails
         *        a consumer that will call methods on {@link IssueDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issueDetails(IssueDetails)
         */
        default Builder issueDetails(Consumer<IssueDetails.Builder> issueDetails) {
            return issueDetails(IssueDetails.builder().applyMutation(issueDetails).build());
        }

        /**
         * <p>
         * The supporting attributes to explain the recommended action.
         * </p>
         * 
         * @param contextAttributes
         *        The supporting attributes to explain the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextAttributes(Collection<ContextAttribute> contextAttributes);

        /**
         * <p>
         * The supporting attributes to explain the recommended action.
         * </p>
         * 
         * @param contextAttributes
         *        The supporting attributes to explain the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextAttributes(ContextAttribute... contextAttributes);

        /**
         * <p>
         * The supporting attributes to explain the recommended action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.ContextAttribute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.ContextAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.ContextAttribute.Builder#build()} is called immediately and
         * its result is passed to {@link #contextAttributes(List<ContextAttribute>)}.
         * 
         * @param contextAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.ContextAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextAttributes(java.util.Collection<ContextAttribute>)
         */
        Builder contextAttributes(Consumer<ContextAttribute.Builder>... contextAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String title;

        private String description;

        private String operation;

        private List<RecommendedActionParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> applyModes = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private IssueDetails issueDetails;

        private List<ContextAttribute> contextAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedAction model) {
            actionId(model.actionId);
            title(model.title);
            description(model.description);
            operation(model.operation);
            parameters(model.parameters);
            applyModes(model.applyModes);
            status(model.status);
            issueDetails(model.issueDetails);
            contextAttributes(model.contextAttributes);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final List<RecommendedActionParameter.Builder> getParameters() {
            List<RecommendedActionParameter.Builder> result = RecommendedActionParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<RecommendedActionParameter.BuilderImpl> parameters) {
            this.parameters = RecommendedActionParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<RecommendedActionParameter> parameters) {
            this.parameters = RecommendedActionParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(RecommendedActionParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<RecommendedActionParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> RecommendedActionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getApplyModes() {
            if (applyModes instanceof SdkAutoConstructList) {
                return null;
            }
            return applyModes;
        }

        public final void setApplyModes(Collection<String> applyModes) {
            this.applyModes = StringListCopier.copy(applyModes);
        }

        @Override
        public final Builder applyModes(Collection<String> applyModes) {
            this.applyModes = StringListCopier.copy(applyModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applyModes(String... applyModes) {
            applyModes(Arrays.asList(applyModes));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final IssueDetails.Builder getIssueDetails() {
            return issueDetails != null ? issueDetails.toBuilder() : null;
        }

        public final void setIssueDetails(IssueDetails.BuilderImpl issueDetails) {
            this.issueDetails = issueDetails != null ? issueDetails.build() : null;
        }

        @Override
        public final Builder issueDetails(IssueDetails issueDetails) {
            this.issueDetails = issueDetails;
            return this;
        }

        public final List<ContextAttribute.Builder> getContextAttributes() {
            List<ContextAttribute.Builder> result = ContextAttributeListCopier.copyToBuilder(this.contextAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextAttributes(Collection<ContextAttribute.BuilderImpl> contextAttributes) {
            this.contextAttributes = ContextAttributeListCopier.copyFromBuilder(contextAttributes);
        }

        @Override
        public final Builder contextAttributes(Collection<ContextAttribute> contextAttributes) {
            this.contextAttributes = ContextAttributeListCopier.copy(contextAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextAttributes(ContextAttribute... contextAttributes) {
            contextAttributes(Arrays.asList(contextAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextAttributes(Consumer<ContextAttribute.Builder>... contextAttributes) {
            contextAttributes(Stream.of(contextAttributes).map(c -> ContextAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecommendedAction build() {
            return new RecommendedAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
