/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on the option groups the DB instance is a member of.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptionGroupMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<OptionGroupMembership.Builder, OptionGroupMembership> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(OptionGroupMembership::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OptionGroupMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String optionGroupName;

    private final String status;

    private OptionGroupMembership(BuilderImpl builder) {
        this.optionGroupName = builder.optionGroupName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the option group that the instance belongs to.
     * </p>
     * 
     * @return The name of the option group that the instance belongs to.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>.
     * </p>
     * 
     * @return The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     *         <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     *         <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and
     *         <code>failed</code>.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroupMembership)) {
            return false;
        }
        OptionGroupMembership other = (OptionGroupMembership) obj;
        return Objects.equals(optionGroupName(), other.optionGroupName()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptionGroupMembership").add("OptionGroupName", optionGroupName()).add("Status", status())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptionGroupMembership, T> g) {
        return obj -> g.apply((OptionGroupMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptionGroupMembership> {
        /**
         * <p>
         * The name of the option group that the instance belongs to.
         * </p>
         * 
         * @param optionGroupName
         *        The name of the option group that the instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
         * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
         * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and
         * <code>failed</code>.
         * </p>
         * 
         * @param status
         *        The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
         *        <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
         *        <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and
         *        <code>failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String optionGroupName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroupMembership model) {
            optionGroupName(model.optionGroupName);
            status(model.status);
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public OptionGroupMembership build() {
            return new OptionGroupMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
