/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbMajorEngineVersionsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbMajorEngineVersionsRequest.Builder, DescribeDbMajorEngineVersionsRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DescribeDbMajorEngineVersionsRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(DescribeDbMajorEngineVersionsRequest::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbMajorEngineVersionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbMajorEngineVersionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            MAJOR_ENGINE_VERSION_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String engine;

    private final String majorEngineVersion;

    private final String marker;

    private final Integer maxRecords;

    private DescribeDbMajorEngineVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The database engine to return major version details for.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aurora-mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-postgresql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-sqlserver-web</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db2-ae</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db2-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mariadb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>postgres</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ex</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-web</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine to return major version details for.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aurora-mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-postgresql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-sqlserver-web</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db2-ae</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db2-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mariadb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>postgres</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ex</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-web</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * A specific database major engine version to return details for.
     * </p>
     * <p>
     * Example: <code>8.4</code>
     * </p>
     * 
     * @return A specific database major engine version to return details for.</p>
     *         <p>
     *         Example: <code>8.4</code>
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
     * available, a pagination token called a marker is included in the response so you can retrieve the remaining
     * results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value
     *         is available, a pagination token called a marker is included in the response so you can retrieve the
     *         remaining results.</p>
     *         <p>
     *         Default: 100
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbMajorEngineVersionsRequest)) {
            return false;
        }
        DescribeDbMajorEngineVersionsRequest other = (DescribeDbMajorEngineVersionsRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(majorEngineVersion(), other.majorEngineVersion())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbMajorEngineVersionsRequest").add("Engine", engine())
                .add("MajorEngineVersion", majorEngineVersion()).add("Marker", marker()).add("MaxRecords", maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Engine", ENGINE_FIELD);
        map.put("MajorEngineVersion", MAJOR_ENGINE_VERSION_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbMajorEngineVersionsRequest, T> g) {
        return obj -> g.apply((DescribeDbMajorEngineVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbMajorEngineVersionsRequest> {
        /**
         * <p>
         * The database engine to return major version details for.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aurora-mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-postgresql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-sqlserver-web</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db2-ae</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db2-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mariadb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>postgres</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ex</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-web</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine to return major version details for.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aurora-mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-postgresql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-sqlserver-web</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db2-ae</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db2-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mariadb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>postgres</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ex</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-web</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * A specific database major engine version to return details for.
         * </p>
         * <p>
         * Example: <code>8.4</code>
         * </p>
         * 
         * @param majorEngineVersion
         *        A specific database major engine version to return details for.</p>
         *        <p>
         *        Example: <code>8.4</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
         * available, a pagination token called a marker is included in the response so you can retrieve the remaining
         * results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more than the <code>MaxRecords</code>
         *        value is available, a pagination token called a marker is included in the response so you can retrieve
         *        the remaining results.</p>
         *        <p>
         *        Default: 100
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String engine;

        private String majorEngineVersion;

        private String marker;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbMajorEngineVersionsRequest model) {
            super(model);
            engine(model.engine);
            majorEngineVersion(model.majorEngineVersion);
            marker(model.marker);
            maxRecords(model.maxRecords);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbMajorEngineVersionsRequest build() {
            return new DescribeDbMajorEngineVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
