/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOptionGroupResponse extends RdsResponse implements
        ToCopyableBuilder<CreateOptionGroupResponse.Builder, CreateOptionGroupResponse> {
    private static final SdkField<OptionGroup> OPTION_GROUP_FIELD = SdkField.<OptionGroup> builder(MarshallingType.SDK_POJO)
            .memberName("OptionGroup").getter(getter(CreateOptionGroupResponse::optionGroup))
            .setter(setter(Builder::optionGroup)).constructor(OptionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OptionGroup optionGroup;

    private CreateOptionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroup = builder.optionGroup;
    }

    /**
     * Returns the value of the OptionGroup property for this object.
     * 
     * @return The value of the OptionGroup property for this object.
     */
    public final OptionGroup optionGroup() {
        return optionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptionGroupResponse)) {
            return false;
        }
        CreateOptionGroupResponse other = (CreateOptionGroupResponse) obj;
        return Objects.equals(optionGroup(), other.optionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOptionGroupResponse").add("OptionGroup", optionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionGroup":
            return Optional.ofNullable(clazz.cast(optionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptionGroup", OPTION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOptionGroupResponse, T> g) {
        return obj -> g.apply((CreateOptionGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateOptionGroupResponse> {
        /**
         * Sets the value of the OptionGroup property for this object.
         *
         * @param optionGroup
         *        The new value for the OptionGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroup(OptionGroup optionGroup);

        /**
         * Sets the value of the OptionGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OptionGroup.Builder} avoiding the need to
         * create one manually via {@link OptionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptionGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #optionGroup(OptionGroup)}.
         * 
         * @param optionGroup
         *        a consumer that will call methods on {@link OptionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroup(OptionGroup)
         */
        default Builder optionGroup(Consumer<OptionGroup.Builder> optionGroup) {
            return optionGroup(OptionGroup.builder().applyMutation(optionGroup).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private OptionGroup optionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOptionGroupResponse model) {
            super(model);
            optionGroup(model.optionGroup);
        }

        public final OptionGroup.Builder getOptionGroup() {
            return optionGroup != null ? optionGroup.toBuilder() : null;
        }

        public final void setOptionGroup(OptionGroup.BuilderImpl optionGroup) {
            this.optionGroup = optionGroup != null ? optionGroup.build() : null;
        }

        @Override
        public final Builder optionGroup(OptionGroup optionGroup) {
            this.optionGroup = optionGroup;
            return this;
        }

        @Override
        public CreateOptionGroupResponse build() {
            return new CreateOptionGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
