/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scaling configuration for an Aurora Serverless v2 DB cluster.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora
 * Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessV2ScalingConfigurationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessV2ScalingConfigurationInfo.Builder, ServerlessV2ScalingConfigurationInfo> {
    private static final SdkField<Double> MIN_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinCapacity").getter(getter(ServerlessV2ScalingConfigurationInfo::minCapacity))
            .setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(ServerlessV2ScalingConfigurationInfo::maxCapacity))
            .setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double minCapacity;

    private final Double maxCapacity;

    private ServerlessV2ScalingConfigurationInfo(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
    }

    /**
     * <p>
     * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can
     * specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is
     * 0.5.
     * </p>
     * 
     * @return The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
     *         You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that
     *         you can use is 0.5.
     */
    public final Double minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can
     * specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use
     * is 128.
     * </p>
     * 
     * @return The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
     *         You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value
     *         that you can use is 128.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessV2ScalingConfigurationInfo)) {
            return false;
        }
        ServerlessV2ScalingConfigurationInfo other = (ServerlessV2ScalingConfigurationInfo) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessV2ScalingConfigurationInfo").add("MinCapacity", minCapacity())
                .add("MaxCapacity", maxCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerlessV2ScalingConfigurationInfo, T> g) {
        return obj -> g.apply((ServerlessV2ScalingConfigurationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessV2ScalingConfigurationInfo> {
        /**
         * <p>
         * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You
         * can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can
         * use is 0.5.
         * </p>
         * 
         * @param minCapacity
         *        The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2
         *        cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The
         *        smallest value that you can use is 0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Double minCapacity);

        /**
         * <p>
         * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You
         * can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you
         * can use is 128.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2
         *        cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The
         *        largest value that you can use is 128.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Double minCapacity;

        private Double maxCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessV2ScalingConfigurationInfo model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
        }

        public final Double getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Double minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        @Override
        public ServerlessV2ScalingConfigurationInfo build() {
            return new ServerlessV2ScalingConfigurationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
