/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveFromGlobalClusterRequest extends RdsRequest implements
        ToCopyableBuilder<RemoveFromGlobalClusterRequest.Builder, RemoveFromGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(RemoveFromGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterIdentifier").getter(getter(RemoveFromGlobalClusterRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD));

    private final String globalClusterIdentifier;

    private final String dbClusterIdentifier;

    private RemoveFromGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
    }

    /**
     * <p>
     * The cluster identifier to detach from the Aurora global database cluster.
     * </p>
     * 
     * @return The cluster identifier to detach from the Aurora global database cluster.
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database
     *         cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFromGlobalClusterRequest)) {
            return false;
        }
        RemoveFromGlobalClusterRequest other = (RemoveFromGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveFromGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("DbClusterIdentifier", dbClusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "DbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFromGlobalClusterRequest, T> g) {
        return obj -> g.apply((RemoveFromGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveFromGlobalClusterRequest> {
        /**
         * <p>
         * The cluster identifier to detach from the Aurora global database cluster.
         * </p>
         * 
         * @param globalClusterIdentifier
         *        The cluster identifier to detach from the Aurora global database cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database
         * cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global
         *        database cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String dbClusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFromGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            dbClusterIdentifier(model.dbClusterIdentifier);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveFromGlobalClusterRequest build() {
            return new RemoveFromGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
