/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommendation for your DB instances, DB clusters, and DB parameter groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<DBRecommendation.Builder, DBRecommendation> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(DBRecommendation::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TypeId")
            .getter(getter(DBRecommendation::typeId)).setter(setter(Builder::typeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeId").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(DBRecommendation::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DBRecommendation::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBRecommendation::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DBRecommendation::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTime").getter(getter(DBRecommendation::updatedTime)).setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()).build();

    private static final SdkField<String> DETECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Detection").getter(getter(DBRecommendation::detection)).setter(setter(Builder::detection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detection").build()).build();

    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Recommendation").getter(getter(DBRecommendation::recommendation))
            .setter(setter(Builder::recommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DBRecommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(DBRecommendation::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<List<RecommendedAction>> RECOMMENDED_ACTIONS_FIELD = SdkField
            .<List<RecommendedAction>> builder(MarshallingType.LIST)
            .memberName("RecommendedActions")
            .getter(getter(DBRecommendation::recommendedActions))
            .setter(setter(Builder::recommendedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendedAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendedAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(DBRecommendation::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(DBRecommendation::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> TYPE_DETECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeDetection").getter(getter(DBRecommendation::typeDetection)).setter(setter(Builder::typeDetection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeDetection").build()).build();

    private static final SdkField<String> TYPE_RECOMMENDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeRecommendation").getter(getter(DBRecommendation::typeRecommendation))
            .setter(setter(Builder::typeRecommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeRecommendation").build())
            .build();

    private static final SdkField<String> IMPACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Impact")
            .getter(getter(DBRecommendation::impact)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()).build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInfo").getter(getter(DBRecommendation::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()).build();

    private static final SdkField<List<DocLink>> LINKS_FIELD = SdkField
            .<List<DocLink>> builder(MarshallingType.LIST)
            .memberName("Links")
            .getter(getter(DBRecommendation::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IssueDetails> ISSUE_DETAILS_FIELD = SdkField.<IssueDetails> builder(MarshallingType.SDK_POJO)
            .memberName("IssueDetails").getter(getter(DBRecommendation::issueDetails)).setter(setter(Builder::issueDetails))
            .constructor(IssueDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            TYPE_ID_FIELD, SEVERITY_FIELD, RESOURCE_ARN_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD,
            DETECTION_FIELD, RECOMMENDATION_FIELD, DESCRIPTION_FIELD, REASON_FIELD, RECOMMENDED_ACTIONS_FIELD, CATEGORY_FIELD,
            SOURCE_FIELD, TYPE_DETECTION_FIELD, TYPE_RECOMMENDATION_FIELD, IMPACT_FIELD, ADDITIONAL_INFO_FIELD, LINKS_FIELD,
            ISSUE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String typeId;

    private final String severity;

    private final String resourceArn;

    private final String status;

    private final Instant createdTime;

    private final Instant updatedTime;

    private final String detection;

    private final String recommendation;

    private final String description;

    private final String reason;

    private final List<RecommendedAction> recommendedActions;

    private final String category;

    private final String source;

    private final String typeDetection;

    private final String typeRecommendation;

    private final String impact;

    private final String additionalInfo;

    private final List<DocLink> links;

    private final IssueDetails issueDetails;

    private DBRecommendation(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.typeId = builder.typeId;
        this.severity = builder.severity;
        this.resourceArn = builder.resourceArn;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
        this.detection = builder.detection;
        this.recommendation = builder.recommendation;
        this.description = builder.description;
        this.reason = builder.reason;
        this.recommendedActions = builder.recommendedActions;
        this.category = builder.category;
        this.source = builder.source;
        this.typeDetection = builder.typeDetection;
        this.typeRecommendation = builder.typeRecommendation;
        this.impact = builder.impact;
        this.additionalInfo = builder.additionalInfo;
        this.links = builder.links;
        this.issueDetails = builder.issueDetails;
    }

    /**
     * <p>
     * The unique identifier of the recommendation.
     * </p>
     * 
     * @return The unique identifier of the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * A value that indicates the type of recommendation. This value determines how the description is rendered.
     * </p>
     * 
     * @return A value that indicates the type of recommendation. This value determines how the description is rendered.
     */
    public final String typeId() {
        return typeId;
    }

    /**
     * <p>
     * The severity level of the recommendation. The severity level can help you decide the urgency with which to
     * address the recommendation.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>high</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>low</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>informational</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The severity level of the recommendation. The severity level can help you decide the urgency with which
     *         to address the recommendation.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>high</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>low</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>informational</code>
     *         </p>
     *         </li>
     */
    public final String severity() {
        return severity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The current status of the recommendation.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The recommendations which are ready for you to apply.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The applied or scheduled recommendations which are in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolved</code> - The recommendations which are completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dismissed</code> - The recommendations that you dismissed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the recommendation.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The recommendations which are ready for you to apply.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The applied or scheduled recommendations which are in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolved</code> - The recommendations which are completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dismissed</code> - The recommendations that you dismissed.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The time when the recommendation was created. For example, <code>2023-09-28T01:13:53.931000+00:00</code>.
     * </p>
     * 
     * @return The time when the recommendation was created. For example, <code>2023-09-28T01:13:53.931000+00:00</code>.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The time when the recommendation was last updated.
     * </p>
     * 
     * @return The time when the recommendation was last updated.
     */
    public final Instant updatedTime() {
        return updatedTime;
    }

    /**
     * <p>
     * A short description of the issue identified for this recommendation. The description might contain markdown.
     * </p>
     * 
     * @return A short description of the issue identified for this recommendation. The description might contain
     *         markdown.
     */
    public final String detection() {
        return detection;
    }

    /**
     * <p>
     * A short description of the recommendation to resolve an issue. The description might contain markdown.
     * </p>
     * 
     * @return A short description of the recommendation to resolve an issue. The description might contain markdown.
     */
    public final String recommendation() {
        return recommendation;
    }

    /**
     * <p>
     * A detailed description of the recommendation. The description might contain markdown.
     * </p>
     * 
     * @return A detailed description of the recommendation. The description might contain markdown.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The reason why this recommendation was created. The information might contain markdown.
     * </p>
     * 
     * @return The reason why this recommendation was created. The information might contain markdown.
     */
    public final String reason() {
        return reason;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendedActions() {
        return recommendedActions != null && !(recommendedActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recommended actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedActions} method.
     * </p>
     * 
     * @return A list of recommended actions.
     */
    public final List<RecommendedAction> recommendedActions() {
        return recommendedActions;
    }

    /**
     * <p>
     * The category of the recommendation.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>performance efficiency</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>security</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reliability</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cost optimization</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>operational excellence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sustainability</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The category of the recommendation.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>performance efficiency</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>security</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reliability</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cost optimization</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>operational excellence</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sustainability</code>
     *         </p>
     *         </li>
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * The Amazon Web Services service that generated the recommendations.
     * </p>
     * 
     * @return The Amazon Web Services service that generated the recommendations.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * A short description of the recommendation type. The description might contain markdown.
     * </p>
     * 
     * @return A short description of the recommendation type. The description might contain markdown.
     */
    public final String typeDetection() {
        return typeDetection;
    }

    /**
     * <p>
     * A short description that summarizes the recommendation to fix all the issues of the recommendation type. The
     * description might contain markdown.
     * </p>
     * 
     * @return A short description that summarizes the recommendation to fix all the issues of the recommendation type.
     *         The description might contain markdown.
     */
    public final String typeRecommendation() {
        return typeRecommendation;
    }

    /**
     * <p>
     * A short description that explains the possible impact of an issue.
     * </p>
     * 
     * @return A short description that explains the possible impact of an issue.
     */
    public final String impact() {
        return impact;
    }

    /**
     * <p>
     * Additional information about the recommendation. The information might contain markdown.
     * </p>
     * 
     * @return Additional information about the recommendation. The information might contain markdown.
     */
    public final String additionalInfo() {
        return additionalInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Links property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A link to documentation that provides additional information about the recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinks} method.
     * </p>
     * 
     * @return A link to documentation that provides additional information about the recommendation.
     */
    public final List<DocLink> links() {
        return links;
    }

    /**
     * <p>
     * Details of the issue that caused the recommendation.
     * </p>
     * 
     * @return Details of the issue that caused the recommendation.
     */
    public final IssueDetails issueDetails() {
        return issueDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(typeId());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(detection());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedActions() ? recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(typeDetection());
        hashCode = 31 * hashCode + Objects.hashCode(typeRecommendation());
        hashCode = 31 * hashCode + Objects.hashCode(impact());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinks() ? links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(issueDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBRecommendation)) {
            return false;
        }
        DBRecommendation other = (DBRecommendation) obj;
        return Objects.equals(recommendationId(), other.recommendationId()) && Objects.equals(typeId(), other.typeId())
                && Objects.equals(severity(), other.severity()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(status(), other.status()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(updatedTime(), other.updatedTime()) && Objects.equals(detection(), other.detection())
                && Objects.equals(recommendation(), other.recommendation()) && Objects.equals(description(), other.description())
                && Objects.equals(reason(), other.reason()) && hasRecommendedActions() == other.hasRecommendedActions()
                && Objects.equals(recommendedActions(), other.recommendedActions())
                && Objects.equals(category(), other.category()) && Objects.equals(source(), other.source())
                && Objects.equals(typeDetection(), other.typeDetection())
                && Objects.equals(typeRecommendation(), other.typeRecommendation()) && Objects.equals(impact(), other.impact())
                && Objects.equals(additionalInfo(), other.additionalInfo()) && hasLinks() == other.hasLinks()
                && Objects.equals(links(), other.links()) && Objects.equals(issueDetails(), other.issueDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBRecommendation").add("RecommendationId", recommendationId()).add("TypeId", typeId())
                .add("Severity", severity()).add("ResourceArn", resourceArn()).add("Status", status())
                .add("CreatedTime", createdTime()).add("UpdatedTime", updatedTime()).add("Detection", detection())
                .add("Recommendation", recommendation()).add("Description", description()).add("Reason", reason())
                .add("RecommendedActions", hasRecommendedActions() ? recommendedActions() : null).add("Category", category())
                .add("Source", source()).add("TypeDetection", typeDetection()).add("TypeRecommendation", typeRecommendation())
                .add("Impact", impact()).add("AdditionalInfo", additionalInfo()).add("Links", hasLinks() ? links() : null)
                .add("IssueDetails", issueDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "TypeId":
            return Optional.ofNullable(clazz.cast(typeId()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "UpdatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        case "Detection":
            return Optional.ofNullable(clazz.cast(detection()));
        case "Recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "RecommendedActions":
            return Optional.ofNullable(clazz.cast(recommendedActions()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "TypeDetection":
            return Optional.ofNullable(clazz.cast(typeDetection()));
        case "TypeRecommendation":
            return Optional.ofNullable(clazz.cast(typeRecommendation()));
        case "Impact":
            return Optional.ofNullable(clazz.cast(impact()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "Links":
            return Optional.ofNullable(clazz.cast(links()));
        case "IssueDetails":
            return Optional.ofNullable(clazz.cast(issueDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBRecommendation, T> g) {
        return obj -> g.apply((DBRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBRecommendation> {
        /**
         * <p>
         * The unique identifier of the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The unique identifier of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * A value that indicates the type of recommendation. This value determines how the description is rendered.
         * </p>
         * 
         * @param typeId
         *        A value that indicates the type of recommendation. This value determines how the description is
         *        rendered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeId(String typeId);

        /**
         * <p>
         * The severity level of the recommendation. The severity level can help you decide the urgency with which to
         * address the recommendation.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>high</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>informational</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param severity
         *        The severity level of the recommendation. The severity level can help you decide the urgency with
         *        which to address the recommendation.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>high</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>low</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>informational</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The current status of the recommendation.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The recommendations which are ready for you to apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The applied or scheduled recommendations which are in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolved</code> - The recommendations which are completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dismissed</code> - The recommendations that you dismissed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the recommendation.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The recommendations which are ready for you to apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The applied or scheduled recommendations which are in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolved</code> - The recommendations which are completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dismissed</code> - The recommendations that you dismissed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The time when the recommendation was created. For example, <code>2023-09-28T01:13:53.931000+00:00</code>.
         * </p>
         * 
         * @param createdTime
         *        The time when the recommendation was created. For example,
         *        <code>2023-09-28T01:13:53.931000+00:00</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The time when the recommendation was last updated.
         * </p>
         * 
         * @param updatedTime
         *        The time when the recommendation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(Instant updatedTime);

        /**
         * <p>
         * A short description of the issue identified for this recommendation. The description might contain markdown.
         * </p>
         * 
         * @param detection
         *        A short description of the issue identified for this recommendation. The description might contain
         *        markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detection(String detection);

        /**
         * <p>
         * A short description of the recommendation to resolve an issue. The description might contain markdown.
         * </p>
         * 
         * @param recommendation
         *        A short description of the recommendation to resolve an issue. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(String recommendation);

        /**
         * <p>
         * A detailed description of the recommendation. The description might contain markdown.
         * </p>
         * 
         * @param description
         *        A detailed description of the recommendation. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason why this recommendation was created. The information might contain markdown.
         * </p>
         * 
         * @param reason
         *        The reason why this recommendation was created. The information might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * A list of recommended actions.
         * </p>
         * 
         * @param recommendedActions
         *        A list of recommended actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(Collection<RecommendedAction> recommendedActions);

        /**
         * <p>
         * A list of recommended actions.
         * </p>
         * 
         * @param recommendedActions
         *        A list of recommended actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(RecommendedAction... recommendedActions);

        /**
         * <p>
         * A list of recommended actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.RecommendedAction.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.RecommendedAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.RecommendedAction.Builder#build()} is called immediately and
         * its result is passed to {@link #recommendedActions(List<RecommendedAction>)}.
         * 
         * @param recommendedActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.RecommendedAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendedActions(java.util.Collection<RecommendedAction>)
         */
        Builder recommendedActions(Consumer<RecommendedAction.Builder>... recommendedActions);

        /**
         * <p>
         * The category of the recommendation.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>performance efficiency</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>security</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reliability</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cost optimization</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operational excellence</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sustainability</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        The category of the recommendation.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>performance efficiency</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>security</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reliability</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cost optimization</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operational excellence</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sustainability</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The Amazon Web Services service that generated the recommendations.
         * </p>
         * 
         * @param source
         *        The Amazon Web Services service that generated the recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * A short description of the recommendation type. The description might contain markdown.
         * </p>
         * 
         * @param typeDetection
         *        A short description of the recommendation type. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeDetection(String typeDetection);

        /**
         * <p>
         * A short description that summarizes the recommendation to fix all the issues of the recommendation type. The
         * description might contain markdown.
         * </p>
         * 
         * @param typeRecommendation
         *        A short description that summarizes the recommendation to fix all the issues of the recommendation
         *        type. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRecommendation(String typeRecommendation);

        /**
         * <p>
         * A short description that explains the possible impact of an issue.
         * </p>
         * 
         * @param impact
         *        A short description that explains the possible impact of an issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impact(String impact);

        /**
         * <p>
         * Additional information about the recommendation. The information might contain markdown.
         * </p>
         * 
         * @param additionalInfo
         *        Additional information about the recommendation. The information might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * A link to documentation that provides additional information about the recommendation.
         * </p>
         * 
         * @param links
         *        A link to documentation that provides additional information about the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Collection<DocLink> links);

        /**
         * <p>
         * A link to documentation that provides additional information about the recommendation.
         * </p>
         * 
         * @param links
         *        A link to documentation that provides additional information about the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(DocLink... links);

        /**
         * <p>
         * A link to documentation that provides additional information about the recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DocLink.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.rds.model.DocLink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DocLink.Builder#build()} is called immediately and its
         * result is passed to {@link #links(List<DocLink>)}.
         * 
         * @param links
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.DocLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #links(java.util.Collection<DocLink>)
         */
        Builder links(Consumer<DocLink.Builder>... links);

        /**
         * <p>
         * Details of the issue that caused the recommendation.
         * </p>
         * 
         * @param issueDetails
         *        Details of the issue that caused the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueDetails(IssueDetails issueDetails);

        /**
         * <p>
         * Details of the issue that caused the recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssueDetails.Builder} avoiding the need
         * to create one manually via {@link IssueDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IssueDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #issueDetails(IssueDetails)}.
         * 
         * @param issueDetails
         *        a consumer that will call methods on {@link IssueDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issueDetails(IssueDetails)
         */
        default Builder issueDetails(Consumer<IssueDetails.Builder> issueDetails) {
            return issueDetails(IssueDetails.builder().applyMutation(issueDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String typeId;

        private String severity;

        private String resourceArn;

        private String status;

        private Instant createdTime;

        private Instant updatedTime;

        private String detection;

        private String recommendation;

        private String description;

        private String reason;

        private List<RecommendedAction> recommendedActions = DefaultSdkAutoConstructList.getInstance();

        private String category;

        private String source;

        private String typeDetection;

        private String typeRecommendation;

        private String impact;

        private String additionalInfo;

        private List<DocLink> links = DefaultSdkAutoConstructList.getInstance();

        private IssueDetails issueDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DBRecommendation model) {
            recommendationId(model.recommendationId);
            typeId(model.typeId);
            severity(model.severity);
            resourceArn(model.resourceArn);
            status(model.status);
            createdTime(model.createdTime);
            updatedTime(model.updatedTime);
            detection(model.detection);
            recommendation(model.recommendation);
            description(model.description);
            reason(model.reason);
            recommendedActions(model.recommendedActions);
            category(model.category);
            source(model.source);
            typeDetection(model.typeDetection);
            typeRecommendation(model.typeRecommendation);
            impact(model.impact);
            additionalInfo(model.additionalInfo);
            links(model.links);
            issueDetails(model.issueDetails);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getTypeId() {
            return typeId;
        }

        public final void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        @Override
        public final Builder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getUpdatedTime() {
            return updatedTime;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final String getDetection() {
            return detection;
        }

        public final void setDetection(String detection) {
            this.detection = detection;
        }

        @Override
        public final Builder detection(String detection) {
            this.detection = detection;
            return this;
        }

        public final String getRecommendation() {
            return recommendation;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final List<RecommendedAction.Builder> getRecommendedActions() {
            List<RecommendedAction.Builder> result = RecommendedActionListCopier.copyToBuilder(this.recommendedActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActions(Collection<RecommendedAction.BuilderImpl> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copyFromBuilder(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<RecommendedAction> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(RecommendedAction... recommendedActions) {
            recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(Consumer<RecommendedAction.Builder>... recommendedActions) {
            recommendedActions(Stream.of(recommendedActions).map(c -> RecommendedAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTypeDetection() {
            return typeDetection;
        }

        public final void setTypeDetection(String typeDetection) {
            this.typeDetection = typeDetection;
        }

        @Override
        public final Builder typeDetection(String typeDetection) {
            this.typeDetection = typeDetection;
            return this;
        }

        public final String getTypeRecommendation() {
            return typeRecommendation;
        }

        public final void setTypeRecommendation(String typeRecommendation) {
            this.typeRecommendation = typeRecommendation;
        }

        @Override
        public final Builder typeRecommendation(String typeRecommendation) {
            this.typeRecommendation = typeRecommendation;
            return this;
        }

        public final String getImpact() {
            return impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final List<DocLink.Builder> getLinks() {
            List<DocLink.Builder> result = DocLinkListCopier.copyToBuilder(this.links);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinks(Collection<DocLink.BuilderImpl> links) {
            this.links = DocLinkListCopier.copyFromBuilder(links);
        }

        @Override
        public final Builder links(Collection<DocLink> links) {
            this.links = DocLinkListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(DocLink... links) {
            links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<DocLink.Builder>... links) {
            links(Stream.of(links).map(c -> DocLink.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final IssueDetails.Builder getIssueDetails() {
            return issueDetails != null ? issueDetails.toBuilder() : null;
        }

        public final void setIssueDetails(IssueDetails.BuilderImpl issueDetails) {
            this.issueDetails = issueDetails != null ? issueDetails.build() : null;
        }

        @Override
        public final Builder issueDetails(IssueDetails issueDetails) {
            this.issueDetails = issueDetails;
            return this;
        }

        @Override
        public DBRecommendation build() {
            return new DBRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
