/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <code>DescribeDBClusterBacktracks</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterBacktrack implements SdkPojo, Serializable,
        ToCopyableBuilder<DBClusterBacktrack.Builder, DBClusterBacktrack> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DBClusterBacktrack::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> BACKTRACK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BacktrackIdentifier").getter(getter(DBClusterBacktrack::backtrackIdentifier))
            .setter(setter(Builder::backtrackIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackIdentifier").build())
            .build();

    private static final SdkField<Instant> BACKTRACK_TO_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BacktrackTo").getter(getter(DBClusterBacktrack::backtrackTo)).setter(setter(Builder::backtrackTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackTo").build()).build();

    private static final SdkField<Instant> BACKTRACKED_FROM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BacktrackedFrom").getter(getter(DBClusterBacktrack::backtrackedFrom))
            .setter(setter(Builder::backtrackedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackedFrom").build()).build();

    private static final SdkField<Instant> BACKTRACK_REQUEST_CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("BacktrackRequestCreationTime")
            .getter(getter(DBClusterBacktrack::backtrackRequestCreationTime))
            .setter(setter(Builder::backtrackRequestCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackRequestCreationTime")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBClusterBacktrack::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            BACKTRACK_IDENTIFIER_FIELD, BACKTRACK_TO_FIELD, BACKTRACKED_FROM_FIELD, BACKTRACK_REQUEST_CREATION_TIME_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbClusterIdentifier;

    private final String backtrackIdentifier;

    private final Instant backtrackTo;

    private final Instant backtrackedFrom;

    private final Instant backtrackRequestCreationTime;

    private final String status;

    private DBClusterBacktrack(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.backtrackIdentifier = builder.backtrackIdentifier;
        this.backtrackTo = builder.backtrackTo;
        this.backtrackedFrom = builder.backtrackedFrom;
        this.backtrackRequestCreationTime = builder.backtrackRequestCreationTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     * </p>
     * 
     * @return Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB
     *         cluster.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Contains the backtrack identifier.
     * </p>
     * 
     * @return Contains the backtrack identifier.
     */
    public final String backtrackIdentifier() {
        return backtrackIdentifier;
    }

    /**
     * <p>
     * The timestamp of the time to which the DB cluster was backtracked.
     * </p>
     * 
     * @return The timestamp of the time to which the DB cluster was backtracked.
     */
    public final Instant backtrackTo() {
        return backtrackTo;
    }

    /**
     * <p>
     * The timestamp of the time from which the DB cluster was backtracked.
     * </p>
     * 
     * @return The timestamp of the time from which the DB cluster was backtracked.
     */
    public final Instant backtrackedFrom() {
        return backtrackedFrom;
    }

    /**
     * <p>
     * The timestamp of the time at which the backtrack was requested.
     * </p>
     * 
     * @return The timestamp of the time at which the backtrack was requested.
     */
    public final Instant backtrackRequestCreationTime() {
        return backtrackRequestCreationTime;
    }

    /**
     * <p>
     * The status of the backtrack. This property returns one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the backtrack. This property returns one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB
     *         cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB
     *         cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackTo());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackRequestCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterBacktrack)) {
            return false;
        }
        DBClusterBacktrack other = (DBClusterBacktrack) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(backtrackIdentifier(), other.backtrackIdentifier())
                && Objects.equals(backtrackTo(), other.backtrackTo())
                && Objects.equals(backtrackedFrom(), other.backtrackedFrom())
                && Objects.equals(backtrackRequestCreationTime(), other.backtrackRequestCreationTime())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBClusterBacktrack").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("BacktrackIdentifier", backtrackIdentifier()).add("BacktrackTo", backtrackTo())
                .add("BacktrackedFrom", backtrackedFrom()).add("BacktrackRequestCreationTime", backtrackRequestCreationTime())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "BacktrackIdentifier":
            return Optional.ofNullable(clazz.cast(backtrackIdentifier()));
        case "BacktrackTo":
            return Optional.ofNullable(clazz.cast(backtrackTo()));
        case "BacktrackedFrom":
            return Optional.ofNullable(clazz.cast(backtrackedFrom()));
        case "BacktrackRequestCreationTime":
            return Optional.ofNullable(clazz.cast(backtrackRequestCreationTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterBacktrack, T> g) {
        return obj -> g.apply((DBClusterBacktrack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterBacktrack> {
        /**
         * <p>
         * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB
         * cluster.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Contains the backtrack identifier.
         * </p>
         * 
         * @param backtrackIdentifier
         *        Contains the backtrack identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackIdentifier(String backtrackIdentifier);

        /**
         * <p>
         * The timestamp of the time to which the DB cluster was backtracked.
         * </p>
         * 
         * @param backtrackTo
         *        The timestamp of the time to which the DB cluster was backtracked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackTo(Instant backtrackTo);

        /**
         * <p>
         * The timestamp of the time from which the DB cluster was backtracked.
         * </p>
         * 
         * @param backtrackedFrom
         *        The timestamp of the time from which the DB cluster was backtracked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackedFrom(Instant backtrackedFrom);

        /**
         * <p>
         * The timestamp of the time at which the backtrack was requested.
         * </p>
         * 
         * @param backtrackRequestCreationTime
         *        The timestamp of the time at which the backtrack was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackRequestCreationTime(Instant backtrackRequestCreationTime);

        /**
         * <p>
         * The status of the backtrack. This property returns one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB
         * cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the backtrack. This property returns one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB
         *        cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB
         *        cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB
         *        cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The backtrack is currently pending application to or rollback from the DB
         *        cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String backtrackIdentifier;

        private Instant backtrackTo;

        private Instant backtrackedFrom;

        private Instant backtrackRequestCreationTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterBacktrack model) {
            dbClusterIdentifier(model.dbClusterIdentifier);
            backtrackIdentifier(model.backtrackIdentifier);
            backtrackTo(model.backtrackTo);
            backtrackedFrom(model.backtrackedFrom);
            backtrackRequestCreationTime(model.backtrackRequestCreationTime);
            status(model.status);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getBacktrackIdentifier() {
            return backtrackIdentifier;
        }

        public final void setBacktrackIdentifier(String backtrackIdentifier) {
            this.backtrackIdentifier = backtrackIdentifier;
        }

        @Override
        public final Builder backtrackIdentifier(String backtrackIdentifier) {
            this.backtrackIdentifier = backtrackIdentifier;
            return this;
        }

        public final Instant getBacktrackTo() {
            return backtrackTo;
        }

        public final void setBacktrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
        }

        @Override
        public final Builder backtrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
            return this;
        }

        public final Instant getBacktrackedFrom() {
            return backtrackedFrom;
        }

        public final void setBacktrackedFrom(Instant backtrackedFrom) {
            this.backtrackedFrom = backtrackedFrom;
        }

        @Override
        public final Builder backtrackedFrom(Instant backtrackedFrom) {
            this.backtrackedFrom = backtrackedFrom;
            return this;
        }

        public final Instant getBacktrackRequestCreationTime() {
            return backtrackRequestCreationTime;
        }

        public final void setBacktrackRequestCreationTime(Instant backtrackRequestCreationTime) {
            this.backtrackRequestCreationTime = backtrackRequestCreationTime;
        }

        @Override
        public final Builder backtrackRequestCreationTime(Instant backtrackRequestCreationTime) {
            this.backtrackRequestCreationTime = backtrackRequestCreationTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public DBClusterBacktrack build() {
            return new DBClusterBacktrack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
