/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse;

public class ListFunctionsByCodeSigningConfigIterable
implements SdkIterable<ListFunctionsByCodeSigningConfigResponse> {
    private final LambdaClient client;
    private final ListFunctionsByCodeSigningConfigRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFunctionsByCodeSigningConfigIterable(LambdaClient client, ListFunctionsByCodeSigningConfigRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFunctionsByCodeSigningConfigResponseFetcher();
    }

    public Iterator<ListFunctionsByCodeSigningConfigResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> functionArns() {
        Function<ListFunctionsByCodeSigningConfigResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionArns() != null) {
                return response.functionArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFunctionsByCodeSigningConfigResponseFetcher
    implements SyncPageFetcher<ListFunctionsByCodeSigningConfigResponse> {
        private ListFunctionsByCodeSigningConfigResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsByCodeSigningConfigResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListFunctionsByCodeSigningConfigResponse nextPage(ListFunctionsByCodeSigningConfigResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsByCodeSigningConfigIterable.this.client.listFunctionsByCodeSigningConfig(ListFunctionsByCodeSigningConfigIterable.this.firstRequest);
            }
            return ListFunctionsByCodeSigningConfigIterable.this.client.listFunctionsByCodeSigningConfig((ListFunctionsByCodeSigningConfigRequest)((Object)ListFunctionsByCodeSigningConfigIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

