/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql;

import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import ru.yandex.qatools.embed.postgresql.AbstractPGProcess;
import ru.yandex.qatools.embed.postgresql.InitDbExecutable;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;
import ru.yandex.qatools.embed.postgresql.ext.SubdirTempDir;

class InitDbProcess<E extends InitDbExecutable>
extends AbstractPGProcess<E, InitDbProcess> {
    public InitDbProcess(Distribution distribution, PostgresConfig config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
    }

    protected List<String> getCommandLine(Distribution distribution, PostgresConfig config, IExtractedFileSet exe) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(exe.executable().getAbsolutePath());
        if (((PostgresConfig)this.getConfig()).credentials() != null) {
            File pwFile = Files.createTempFile((IDirectory)SubdirTempDir.defaultInstance(), (String)("pwfile" + UUID.randomUUID()));
            Files.write((String)((PostgresConfig)this.getConfig()).credentials().password(), (File)pwFile);
            ret.addAll(Arrays.asList("-A", "password", "-U", ((PostgresConfig)this.getConfig()).credentials().username(), "--pwfile=" + pwFile.getAbsolutePath()));
        }
        if (distribution.getPlatform() == Platform.Windows) {
            ret.addAll(config.getAdditionalInitDbParams());
        }
        ret.add(config.storage().dbDir().getAbsolutePath());
        if (distribution.getPlatform() != Platform.Windows) {
            ret.addAll(config.getAdditionalInitDbParams());
        }
        return ret;
    }

    protected void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("database system is ready to accept connections", new HashSet<String>(Arrays.asList("[initdb error]")), StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        logWatch.waitForResult(((PostgresConfig)this.getConfig()).timeout().startupTimeout());
    }
}

