/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.mrc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.CompilerMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import pw.krejci.mrc.CompileConfiguration;
import pw.krejci.mrc.MultiReleaseJarSupport;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompileMojo
extends CompilerMojo {
    @Parameter(defaultValue="${basedir}/src/main/java-mr")
    private File multiReleaseSourcesDirectory;
    @Parameter
    private List<CompileConfiguration> perReleaseConfiguration;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    private CompileConfiguration currentConfiguration;
    private String currentSourceDirectory;
    private String defaultOutputDirectory;
    private String defaultSourceDirectory;
    private boolean compilingModuleDescriptor;

    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (!MultiReleaseJarSupport.isAvailable() || !this.multiReleaseSourcesDirectory.exists()) {
            if (!MultiReleaseJarSupport.isAvailable()) {
                this.getLog().info((CharSequence)"This java version does not support multi-release jars.");
            }
            super.execute();
            return;
        }
        Map<Object, Object> configMap = this.perReleaseConfiguration == null || this.perReleaseConfiguration.isEmpty() ? Collections.emptyMap() : this.perReleaseConfiguration.stream().collect(Collectors.toMap(CompileConfiguration::getRelease, Function.identity()));
        this.defaultOutputDirectory = this.getProject().getBuild().getOutputDirectory();
        this.defaultSourceDirectory = this.getProject().getBuild().getSourceDirectory();
        super.execute();
        try {
            for (File mrBase : this.multiReleaseSourcesDirectory.listFiles(File::isDirectory)) {
                File moduleDescriptor;
                String release = mrBase.getName();
                this.currentConfiguration = configMap.containsKey(release) ? (CompileConfiguration)configMap.get(release) : CompileConfiguration.emptyForRelease(release);
                this.currentSourceDirectory = mrBase.getAbsolutePath();
                this.getProject().getBuild().setOutputDirectory(this.getOutputDirectory().toString());
                if (this.currentConfiguration.getConfiguration().getRelease() == null) {
                    this.currentConfiguration.getConfiguration().setRelease(release);
                }
                if (this.currentConfiguration.getConfiguration().getSource() == null) {
                    this.currentConfiguration.getConfiguration().setSource(release);
                }
                if (this.currentConfiguration.getConfiguration().getTarget() == null) {
                    this.currentConfiguration.getConfiguration().setTarget(release);
                }
                if (this.currentConfiguration.getConfiguration().getCompilerArgs() != null) {
                    this.compilerArgs = this.currentConfiguration.getConfiguration().getCompilerArgs();
                }
                if (this.currentConfiguration.getConfiguration().getRelease() != null) {
                    this.release = this.currentConfiguration.getConfiguration().getRelease();
                }
                if ((moduleDescriptor = new File(mrBase, "module-info.java")).exists()) {
                    File copiedSourcesRoot = new File(new File(this.defaultOutputDirectory).getParent(), "sources-" + release);
                    File sources = new File(copiedSourcesRoot, "sources");
                    File descriptor = new File(copiedSourcesRoot, "descriptor");
                    FileUtils.copyDirectory((File)mrBase, (File)sources);
                    FileUtils.moveFile((File)new File(sources, "module-info.java"), (File)new File(descriptor, "module-info.java"));
                    this.currentSourceDirectory = descriptor.getAbsolutePath();
                    Set<String> configuredIncludes = this.currentConfiguration.getConfiguration().getIncludes();
                    Set<String> configuredExcludes = this.currentConfiguration.getConfiguration().getExcludes();
                    this.currentConfiguration.getConfiguration().setIncludes(Collections.singleton("module-info.java"));
                    this.currentConfiguration.getConfiguration().setExcludes(Collections.emptySet());
                    this.compilingModuleDescriptor = true;
                    super.execute();
                    this.currentSourceDirectory = sources.getAbsolutePath();
                    this.currentConfiguration.getConfiguration().setIncludes(configuredIncludes);
                    this.currentConfiguration.getConfiguration().setExcludes(configuredExcludes);
                    this.compilingModuleDescriptor = false;
                } else {
                    this.currentSourceDirectory = mrBase.getAbsolutePath();
                }
                super.execute();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to prepare multi-release sources for staged compilation.", (Exception)e);
        }
        finally {
            this.getProject().getBuild().setOutputDirectory(this.defaultOutputDirectory);
        }
    }

    protected List<String> getCompileSourceRoots() {
        if (MultiReleaseJarSupport.isAvailable()) {
            return super.getCompileSourceRoots().stream().flatMap(e -> {
                if (this.currentConfiguration != null && e.equals(this.defaultSourceDirectory)) {
                    if (this.compilingModuleDescriptor) {
                        return Stream.of(this.currentSourceDirectory, this.defaultSourceDirectory);
                    }
                    return Stream.of(this.currentSourceDirectory);
                }
                return Stream.of(e);
            }).collect(Collectors.toList());
        }
        return super.getCompileSourceRoots();
    }

    protected List<String> getClasspathElements() {
        if (MultiReleaseJarSupport.isAvailable()) {
            String currentOutput = this.getProject().getBuild().getOutputDirectory();
            return super.getClasspathElements().stream().map(e -> this.defaultOutputDirectory != null && e.equals(currentOutput) ? this.defaultOutputDirectory : e).collect(Collectors.toList());
        }
        return super.getClasspathElements();
    }

    protected File getOutputDirectory() {
        if (!MultiReleaseJarSupport.isAvailable() || this.currentConfiguration == null) {
            return super.getOutputDirectory();
        }
        return this.compilingModuleDescriptor ? CompileMojo.getOutputDirectoryForModuleDescriptor(super.getOutputDirectory(), this.currentConfiguration.getRelease()) : CompileMojo.getOutputDirectory(super.getOutputDirectory(), this.currentConfiguration.getRelease());
    }

    protected static File getOutputDirectory(File defaultOutputDirectory, String modifier) {
        Path p = defaultOutputDirectory.toPath();
        Path parent = p.getParent();
        Path fileName = p.getFileName();
        Path newPath = parent.resolve(fileName.toString() + "-" + modifier);
        return newPath.toFile();
    }

    protected static File getOutputDirectoryForModuleDescriptor(File defaultOutputDirectory, String modifier) {
        Path p = defaultOutputDirectory.toPath();
        Path parent = p.getParent();
        Path fileName = p.getFileName();
        Path newPath = parent.resolve(fileName.toString() + "-" + modifier + "-descriptor");
        return newPath.toFile();
    }

    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        Set excludes;
        Set includes;
        if (MultiReleaseJarSupport.isAvailable()) {
            includes = this.getOrCall(CompileConfiguration.Configuration::getIncludes, () -> this.includes);
            excludes = this.getOrCall(CompileConfiguration.Configuration::getExcludes, () -> this.excludes);
        } else {
            includes = this.includes;
            excludes = this.excludes;
        }
        if (includes.isEmpty() && excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (includes.isEmpty()) {
                includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, includes, excludes);
        }
        return scanner;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        Set excludes;
        Set<String> includes;
        if (MultiReleaseJarSupport.isAvailable()) {
            includes = this.getOrCall(CompileConfiguration.Configuration::getIncludes, () -> this.includes);
            excludes = this.getOrCall(CompileConfiguration.Configuration::getExcludes, () -> this.excludes);
        } else {
            includes = this.includes;
            excludes = this.excludes;
        }
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (includes.isEmpty() && excludes.isEmpty()) {
            includes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(includes, Collections.emptySet());
        } else {
            if (includes.isEmpty()) {
                includes.add(defaultIncludePattern);
            }
            scanner = new SimpleSourceInclusionScanner(includes, excludes);
        }
        return scanner;
    }

    protected String getSource() {
        return this.getOrCall(CompileConfiguration.Configuration::getSource, () -> super.getSource());
    }

    protected String getTarget() {
        return this.getOrCall(CompileConfiguration.Configuration::getTarget, () -> super.getTarget());
    }

    protected String getRelease() {
        return this.getOrCall(CompileConfiguration.Configuration::getRelease, () -> super.getRelease());
    }

    protected String getCompilerArgument() {
        return this.getOrCall(CompileConfiguration.Configuration::getCompilerArgument, () -> super.getCompilerArgument());
    }

    protected Map<String, String> getCompilerArguments() {
        return this.getOrCall(CompileConfiguration.Configuration::getCompilerArguments, () -> super.getCompilerArguments());
    }

    protected File getGeneratedSourcesDirectory() {
        return this.getOrCall(CompileConfiguration.Configuration::getGeneratedSourcesDirectory, () -> super.getGeneratedSourcesDirectory());
    }

    private <T> T getOrCall(Function<CompileConfiguration.Configuration, T> configOption, Supplier<T> call) {
        T val;
        if (!MultiReleaseJarSupport.isAvailable()) {
            return call.get();
        }
        if (this.currentConfiguration != null && (val = configOption.apply(this.currentConfiguration.getConfiguration())) != null) {
            return val;
        }
        return call.get();
    }
}

