/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.zeromq.ZAgent;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZPoller;
import org.zeromq.ZStar;
import zmq.util.Objects;

public class ZActor
extends ZStar {
    public ZActor(Actor actor, String motdelafin, Object ... args) {
        super(new ActorFortune(actor), motdelafin, args);
    }

    @Deprecated
    public ZActor(ZAgent.SelectorCreator selector, Actor actor, String motdelafin, Object ... args) {
        this(actor, motdelafin, args);
    }

    @Deprecated
    public ZActor(ZContext context, ZAgent.SelectorCreator selector, Actor actor, String motdelafin, Object ... args) {
        this(context, actor, motdelafin, args);
    }

    public ZActor(ZContext context, Actor actor, String motdelafin, Object ... args) {
        super(context, (ZStar.Fortune)new ActorFortune(actor), motdelafin, args);
    }

    private static final class ActorFortune
    implements ZStar.Fortune {
        private final Actor actor;

        public ActorFortune(Actor actor) {
            Objects.requireNonNull(actor, "Actor shall be set to a non-null value");
            this.actor = actor;
        }

        @Override
        public String premiere(ZMQ.Socket mic, Object ... args) {
            return this.actor.premiere(mic);
        }

        @Override
        public ZStar.Star create(ZContext ctx, ZMQ.Socket pipe, int count, ZStar.Star previous, Object ... args) {
            return new Double(ctx, pipe, this.actor, args);
        }

        @Override
        public boolean interview(ZMQ.Socket mic) {
            return this.actor.finished(mic);
        }

        @Override
        public void party(ZContext ctx) {
        }
    }

    public static interface Actor {
        public String premiere(ZMQ.Socket var1);

        public List<ZMQ.Socket> createSockets(ZContext var1, Object ... var2);

        public void start(ZMQ.Socket var1, List<ZMQ.Socket> var2, ZPoller var3);

        public long looping(ZMQ.Socket var1, ZPoller var2);

        public boolean backstage(ZMQ.Socket var1, ZPoller var2, int var3);

        public boolean stage(ZMQ.Socket var1, ZMQ.Socket var2, ZPoller var3, int var4);

        public boolean looped(ZMQ.Socket var1, ZPoller var2);

        public void closed(ZMQ.Socket var1);

        public boolean destroyed(ZContext var1, ZMQ.Socket var2, ZPoller var3);

        public boolean finished(ZMQ.Socket var1);
    }

    private static final class Double
    implements ZPoller.EventsHandler,
    ZStar.Star {
        private final ZPoller poller;
        private final ZMQ.Socket pipe;
        private final List<ZMQ.Socket> sockets;
        private final Actor actor;
        private final ZContext context;

        public Double(ZContext ctx, ZMQ.Socket pipe, Actor actor, Object ... args) {
            this.context = ctx;
            this.pipe = pipe;
            this.actor = actor;
            List<ZMQ.Socket> created = actor.createSockets(ctx, args);
            assert (created != null);
            this.sockets = new ArrayList<ZMQ.Socket>(created);
            this.poller = new ZPoller(ctx);
            this.poller.setGlobalHandler(this);
        }

        @Override
        public void prepare() {
            this.poller.register(this.pipe, 1);
            this.actor.start(this.pipe, Collections.unmodifiableList(this.sockets), this.poller);
        }

        @Override
        public int breathe() {
            long timeout = this.actor.looping(this.pipe, this.poller);
            return this.poller.poll(timeout);
        }

        @Override
        public boolean act(int events) {
            return events >= 0;
        }

        @Override
        public boolean entract() {
            return this.actor.looped(this.pipe, this.poller);
        }

        @Override
        public boolean renews() {
            Iterator<ZMQ.Socket> iter = this.sockets.iterator();
            while (iter.hasNext()) {
                ZMQ.Socket socket = iter.next();
                iter.remove();
                if (socket == null) continue;
                this.poller.unregister(socket);
                socket.close();
                this.actor.closed(socket);
            }
            return this.actor.destroyed(this.context, this.pipe, this.poller);
        }

        @Override
        public boolean events(SelectableChannel channel, int events) {
            return true;
        }

        @Override
        public boolean events(ZMQ.Socket socket, int events) {
            if (socket != this.pipe) {
                return this.actor.stage(socket, this.pipe, this.poller, events);
            }
            return this.actor.backstage(this.pipe, this.poller, events);
        }
    }

    public static class Duo
    implements Actor {
        private final Actor main;
        private final Actor shadow;

        public Duo(Actor main, Actor shadow) {
            Objects.requireNonNull(main, "Actor shall be set to a non-null value");
            Objects.requireNonNull(shadow, "Shadow Actor shall be set to a non-null value");
            this.main = main;
            this.shadow = shadow;
        }

        @Override
        public String premiere(ZMQ.Socket pipe) {
            this.shadow.premiere(pipe);
            return this.main.premiere(pipe);
        }

        @Override
        public List<ZMQ.Socket> createSockets(ZContext ctx, Object ... args) {
            this.shadow.createSockets(ctx, args);
            return this.main.createSockets(ctx, args);
        }

        @Override
        public void start(ZMQ.Socket pipe, List<ZMQ.Socket> sockets, ZPoller poller) {
            this.shadow.start(pipe, sockets, poller);
            this.main.start(pipe, sockets, poller);
        }

        @Override
        public long looping(ZMQ.Socket pipe, ZPoller poller) {
            this.shadow.looping(pipe, poller);
            return this.main.looping(pipe, poller);
        }

        @Override
        public boolean backstage(ZMQ.Socket pipe, ZPoller poller, int events) {
            this.shadow.backstage(pipe, poller, events);
            return this.main.backstage(pipe, poller, events);
        }

        @Override
        public boolean stage(ZMQ.Socket socket, ZMQ.Socket pipe, ZPoller poller, int events) {
            this.shadow.stage(socket, pipe, poller, events);
            return this.main.stage(socket, pipe, poller, events);
        }

        @Override
        public boolean looped(ZMQ.Socket pipe, ZPoller poller) {
            this.shadow.looped(pipe, poller);
            return this.main.looped(pipe, poller);
        }

        @Override
        public void closed(ZMQ.Socket socket) {
            this.shadow.closed(socket);
            this.main.closed(socket);
        }

        @Override
        public boolean destroyed(ZContext ctx, ZMQ.Socket pipe, ZPoller poller) {
            this.shadow.destroyed(ctx, pipe, poller);
            return this.main.destroyed(ctx, pipe, poller);
        }

        @Override
        public boolean finished(ZMQ.Socket pipe) {
            this.shadow.finished(pipe);
            return this.main.finished(pipe);
        }
    }

    public static class SimpleActor
    implements Actor {
        @Override
        public String premiere(ZMQ.Socket pipe) {
            return null;
        }

        @Override
        public List<ZMQ.Socket> createSockets(ZContext ctx, Object ... args) {
            return Collections.emptyList();
        }

        @Override
        public void start(ZMQ.Socket pipe, List<ZMQ.Socket> sockets, ZPoller poller) {
        }

        @Override
        public long looping(ZMQ.Socket pipe, ZPoller poller) {
            return -1L;
        }

        @Override
        public boolean backstage(ZMQ.Socket pipe, ZPoller poller, int events) {
            return false;
        }

        @Override
        public boolean stage(ZMQ.Socket socket, ZMQ.Socket pipe, ZPoller poller, int events) {
            return false;
        }

        @Override
        public boolean looped(ZMQ.Socket pipe, ZPoller poller) {
            return true;
        }

        @Override
        public void closed(ZMQ.Socket socket) {
        }

        @Override
        public boolean destroyed(ZContext ctx, ZMQ.Socket pipe, ZPoller poller) {
            return false;
        }

        @Override
        public boolean finished(ZMQ.Socket pipe) {
            return true;
        }
    }
}

