/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.Assert;

public class SimpleNamespaceContext
implements NamespaceContext {
    private Map prefixToNamespaceUri = new HashMap();
    private Map namespaceUriToPrefixes = new HashMap();
    private String defaultNamespaceUri = "";

    public String getNamespaceURI(String prefix) {
        Assert.notNull((Object)prefix, (String)"prefix is null");
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if ("".equals(prefix)) {
            return this.defaultNamespaceUri;
        }
        if (this.prefixToNamespaceUri.containsKey(prefix)) {
            return (String)this.prefixToNamespaceUri.get(prefix);
        }
        return "";
    }

    public String getPrefix(String namespaceUri) {
        List prefixes = this.getPrefixesInternal(namespaceUri);
        return prefixes.isEmpty() ? null : (String)prefixes.get(0);
    }

    public Iterator getPrefixes(String namespaceUri) {
        return this.getPrefixesInternal(namespaceUri).iterator();
    }

    public void setBindings(Map bindings) {
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.bindNamespaceUri((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void bindDefaultNamespaceUri(String namespaceUri) {
        this.bindNamespaceUri("", namespaceUri);
    }

    public void bindNamespaceUri(String prefix, String namespaceUri) {
        Assert.notNull((Object)prefix, (String)"No prefix given");
        Assert.notNull((Object)namespaceUri, (String)"No namespaceUri given");
        if ("".equals(prefix)) {
            this.defaultNamespaceUri = namespaceUri;
        } else if ("xml".equals(prefix)) {
            Assert.isTrue((boolean)"http://www.w3.org/XML/1998/namespace".equals(namespaceUri), (String)("Prefix \"" + prefix + "\" bound to namespace \"" + namespaceUri + "\" (should be \"" + "http://www.w3.org/XML/1998/namespace" + "\")"));
        } else if ("xmlns".equals(prefix)) {
            Assert.isTrue((boolean)"http://www.w3.org/2000/xmlns/".equals(namespaceUri), (String)("Prefix \"" + prefix + "\" bound to namespace \"" + namespaceUri + "\" (should be \"" + "http://www.w3.org/2000/xmlns/" + "\")"));
        } else {
            this.prefixToNamespaceUri.put(prefix, namespaceUri);
            this.getPrefixesInternal(namespaceUri).add(prefix);
        }
    }

    public void clear() {
        this.defaultNamespaceUri = "";
        this.prefixToNamespaceUri.clear();
        this.namespaceUriToPrefixes.clear();
    }

    public Iterator getBoundPrefixes() {
        return this.prefixToNamespaceUri.keySet().iterator();
    }

    private List getPrefixesInternal(String namespaceUri) {
        if (this.defaultNamespaceUri.equals(namespaceUri)) {
            return Collections.singletonList("");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            return Collections.singletonList("xml");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            return Collections.singletonList("xmlns");
        }
        ArrayList list = (ArrayList)this.namespaceUriToPrefixes.get(namespaceUri);
        if (list == null) {
            list = new ArrayList();
            this.namespaceUriToPrefixes.put(namespaceUri, list);
        }
        return list;
    }

    public void removeBinding(String prefix) {
        if ("".equals(prefix)) {
            this.defaultNamespaceUri = "";
        } else {
            String namespaceUri = (String)this.prefixToNamespaceUri.get(prefix);
            List prefixes = this.getPrefixesInternal(namespaceUri);
            prefixes.remove(prefix);
        }
    }

    public boolean hasBinding(String prefix) {
        if ("".equals(prefix)) {
            return !this.defaultNamespaceUri.equals("");
        }
        return this.prefixToNamespaceUri.containsKey(prefix);
    }
}

