/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

public class MarshallingView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private Marshaller marshaller;
    private String modelKey;

    public MarshallingView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    public MarshallingView(Marshaller marshaller) {
        this();
        Assert.notNull((Object)marshaller, (String)"Marshaller must not be null");
        this.marshaller = marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }

    protected void initApplicationContext() {
        Assert.notNull((Object)this.marshaller, (String)"Property 'marshaller' is required");
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object toBeMarshalled = this.locateToBeMarshalled(model);
        if (toBeMarshalled == null) {
            throw new IllegalStateException("Unable to locate object to be marshalled in model: " + model);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        this.marshaller.marshal(toBeMarshalled, (Result)new StreamResult(bos));
        this.setResponseContentType(request, response);
        response.setContentLength(bos.size());
        StreamUtils.copy((byte[])bos.toByteArray(), (OutputStream)response.getOutputStream());
    }

    protected Object locateToBeMarshalled(Map<String, Object> model) throws IllegalStateException {
        if (this.modelKey != null) {
            Object obj = model.get(this.modelKey);
            if (obj == null) {
                throw new IllegalStateException("Model contains no object with key [" + this.modelKey + "]");
            }
            if (!this.marshaller.supports(obj.getClass())) {
                throw new IllegalStateException("Model object [" + obj + "] retrieved via key [" + this.modelKey + "] is not supported by the Marshaller");
            }
            return obj;
        }
        for (Object obj : model.values()) {
            if (obj == null || model.size() != 1 && obj instanceof BindingResult || !this.marshaller.supports(obj.getClass())) continue;
            return obj;
        }
        return null;
    }
}

