/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.multipart.support.RequestPartServletServerHttpRequest;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.util.WebUtils;

public class RequestPartMethodArgumentResolver
extends AbstractMessageConverterMethodArgumentResolver {
    public RequestPartMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            return false;
        }
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        return "javax.servlet.http.Part".equals(parameter.getParameterType().getName());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        boolean isRequired;
        Object arg;
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)servletRequest, MultipartHttpServletRequest.class);
        String partName = this.getPartName(parameter);
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFile(partName);
        } else if (this.isMultipartFileCollection(parameter)) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFiles(partName);
        } else if (this.isMultipartFileArray(parameter)) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            List files = multipartRequest.getFiles(partName);
            arg = files.toArray(new MultipartFile[files.size()]);
        } else if ("javax.servlet.http.Part".equals(parameter.getParameterType().getName())) {
            RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
            arg = servletRequest.getPart(partName);
        } else if (this.isPartCollection(parameter)) {
            RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
            arg = new ArrayList(servletRequest.getParts());
        } else if (this.isPartArray(parameter)) {
            RequestPartMethodArgumentResolver.assertIsMultipartRequest(servletRequest);
            arg = RequestPartResolver.resolvePart(servletRequest);
        } else {
            try {
                RequestPartServletServerHttpRequest inputMessage = new RequestPartServletServerHttpRequest(servletRequest, partName);
                arg = this.readWithMessageConverters((HttpInputMessage)inputMessage, parameter, (Type)parameter.getParameterType());
                WebDataBinder binder = binderFactory.createBinder(request, arg, partName);
                if (arg != null) {
                    this.validate(binder, parameter);
                }
                mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + partName, (Object)binder.getBindingResult());
            }
            catch (MissingServletRequestPartException ex) {
                arg = null;
            }
        }
        RequestPart annot = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean bl = isRequired = annot == null || annot.required();
        if (arg == null && isRequired) {
            throw new MissingServletRequestPartException(partName);
        }
        return arg;
    }

    private static void assertIsMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/")) {
            throw new MultipartException("The current request is not a multipart request");
        }
    }

    private String getPartName(MethodParameter parameter) {
        String partName;
        RequestPart annot = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        String string = partName = annot != null ? annot.value() : "";
        if (partName.length() == 0) {
            partName = parameter.getParameterName();
            Assert.notNull((Object)partName, (String)("Request part name for argument type [" + parameter.getParameterType().getName() + "] not specified, and parameter name information not found in class file either."));
        }
        return partName;
    }

    private boolean isMultipartFileCollection(MethodParameter parameter) {
        Class<?> collectionType = this.getCollectionParameterType(parameter);
        return collectionType != null && collectionType.equals(MultipartFile.class);
    }

    private boolean isMultipartFileArray(MethodParameter parameter) {
        Class<?> paramType = parameter.getParameterType().getComponentType();
        return paramType != null && MultipartFile.class.equals(paramType);
    }

    private boolean isPartCollection(MethodParameter parameter) {
        Class<?> collectionType = this.getCollectionParameterType(parameter);
        return collectionType != null && "javax.servlet.http.Part".equals(collectionType.getName());
    }

    private boolean isPartArray(MethodParameter parameter) {
        Class<?> paramType = parameter.getParameterType().getComponentType();
        return paramType != null && "javax.servlet.http.Part".equals(paramType.getName());
    }

    private Class<?> getCollectionParameterType(MethodParameter parameter) {
        Class valueType;
        Class paramType = parameter.getParameterType();
        if ((Collection.class.equals((Object)paramType) || List.class.isAssignableFrom(paramType)) && (valueType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)parameter)) != null) {
            return valueType;
        }
        return null;
    }

    private void validate(WebDataBinder binder, MethodParameter parameter) throws MethodArgumentNotValidException {
        Annotation[] annotations;
        for (Annotation annot : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            binder.validate(objectArray);
            BindingResult bindingResult = binder.getBindingResult();
            if (!bindingResult.hasErrors() || !this.isBindingErrorFatal(parameter)) continue;
            throw new MethodArgumentNotValidException(parameter, bindingResult);
        }
    }

    private boolean isBindingErrorFatal(MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    private static class RequestPartResolver {
        private RequestPartResolver() {
        }

        public static Object resolvePart(HttpServletRequest servletRequest) throws Exception {
            Collection parts = servletRequest.getParts();
            return parts.toArray(new Part[parts.size()]);
        }
    }
}

