/*
 * Copyright 2002-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.http.client;

import java.io.IOException;

import org.springframework.http.HttpStatusCode;

/**
 * Abstract base for {@link ClientHttpResponse}.
 *
 * @author Arjen Poutsma
 * @since 3.1.1
 * @deprecated as of 6.0, with no direct replacement; scheduled for removal in 6.2
 */
@Deprecated(since = "6.0")
public abstract class AbstractClientHttpResponse implements ClientHttpResponse {

	@Override
	public HttpStatusCode getStatusCode() throws IOException {
		return HttpStatusCode.valueOf(getRawStatusCode());
	}

}
