/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.test.web.reactive.server.DefaultWebTestClientBuilder;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.Assert;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionManager;

abstract class AbstractMockServerSpec<B extends WebTestClient.MockServerSpec<B>>
implements WebTestClient.MockServerSpec<B> {
    private final List<WebFilter> filters = new ArrayList<WebFilter>(4);
    private WebSessionManager sessionManager = new DefaultWebSessionManager();
    private final List<MockServerConfigurer> configurers = new ArrayList<MockServerConfigurer>(4);

    AbstractMockServerSpec() {
    }

    @Override
    public <T extends B> T webFilter(WebFilter ... filter) {
        this.filters.addAll(Arrays.asList(filter));
        return this.self();
    }

    @Override
    public <T extends B> T webSessionManager(WebSessionManager sessionManager) {
        Assert.notNull((Object)sessionManager, (String)"WebSessionManager must not be null.");
        this.sessionManager = sessionManager;
        return this.self();
    }

    @Override
    public <T extends B> T apply(MockServerConfigurer configurer) {
        configurer.afterConfigureAdded(this);
        this.configurers.add(configurer);
        return this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    @Override
    public WebTestClient.Builder configureClient() {
        WebHttpHandlerBuilder builder = this.initHttpHandlerBuilder();
        builder.filters(theFilters -> theFilters.addAll(0, this.filters));
        builder.sessionManager(this.sessionManager);
        this.configurers.forEach(configurer -> configurer.beforeServerCreated(builder));
        return new DefaultWebTestClientBuilder(builder);
    }

    protected abstract WebHttpHandlerBuilder initHttpHandlerBuilder();

    @Override
    public WebTestClient build() {
        return this.configureClient().build();
    }
}

