/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.web.server.logout;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class OidcClientInitiatedServerLogoutSuccessHandler
implements ServerLogoutSuccessHandler {
    private final ServerRedirectStrategy redirectStrategy = new DefaultServerRedirectStrategy();
    private final RedirectServerLogoutSuccessHandler serverLogoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private String postLogoutRedirectUri;

    public OidcClientInitiatedServerLogoutSuccessHandler(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        return Mono.just((Object)authentication).filter(OAuth2AuthenticationToken.class::isInstance).filter(token -> authentication.getPrincipal() instanceof OidcUser).map(OAuth2AuthenticationToken.class::cast).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId).flatMap(this.clientRegistrationRepository::findByRegistrationId).flatMap(clientRegistration -> {
            URI endSessionEndpoint = this.endSessionEndpoint((ClientRegistration)clientRegistration);
            if (endSessionEndpoint == null) {
                return Mono.empty();
            }
            String idToken = this.idToken(authentication);
            URI postLogoutRedirectUri = this.postLogoutRedirectUri(exchange.getExchange().getRequest());
            return Mono.just((Object)this.endpointUri(endSessionEndpoint, idToken, postLogoutRedirectUri));
        }).switchIfEmpty(this.serverLogoutSuccessHandler.onLogoutSuccess(exchange, authentication).then(Mono.empty())).flatMap(endpointUri -> this.redirectStrategy.sendRedirect(exchange.getExchange(), endpointUri));
    }

    private URI endSessionEndpoint(ClientRegistration clientRegistration) {
        Object endSessionEndpoint;
        URI result = null;
        if (clientRegistration != null && (endSessionEndpoint = clientRegistration.getProviderDetails().getConfigurationMetadata().get("end_session_endpoint")) != null) {
            result = URI.create(endSessionEndpoint.toString());
        }
        return result;
    }

    private URI endpointUri(URI endSessionEndpoint, String idToken, URI postLogoutRedirectUri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{idToken});
        if (postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUri();
    }

    private String idToken(Authentication authentication) {
        return ((OidcUser)authentication.getPrincipal()).getIdToken().getTokenValue();
    }

    private URI postLogoutRedirectUri(ServerHttpRequest request) {
        if (this.postLogoutRedirectUri == null) {
            return null;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getURI()).replacePath(request.getPath().contextPath().value()).replaceQuery(null).fragment(null).build();
        return UriComponentsBuilder.fromUriString((String)this.postLogoutRedirectUri).buildAndExpand(Collections.singletonMap("baseUrl", uriComponents.toUriString())).toUri();
    }

    @Deprecated
    public void setPostLogoutRedirectUri(URI postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be empty");
        this.postLogoutRedirectUri = postLogoutRedirectUri.toASCIIString();
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void setLogoutSuccessUrl(URI logoutSuccessUrl) {
        Assert.notNull((Object)logoutSuccessUrl, (String)"logoutSuccessUrl cannot be null");
        this.serverLogoutSuccessHandler.setLogoutSuccessUrl(logoutSuccessUrl);
    }
}

