/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.DispatcherTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class AbstractRequestMatcherRegistry<C> {
    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent;
    private static final RequestMatcher ANY_REQUEST;
    private ApplicationContext context;
    private boolean anyRequestConfigured = false;

    protected final void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context;
    }

    public C anyRequest() {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure anyRequest after itself");
        C configurer = this.requestMatchers(ANY_REQUEST);
        this.anyRequestConfigured = true;
        return configurer;
    }

    @Deprecated
    public C antMatchers(HttpMethod method) {
        return this.antMatchers(method, "/**");
    }

    @Deprecated
    public C antMatchers(HttpMethod method, String ... antPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure antMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.antMatchers(method, antPatterns));
    }

    @Deprecated
    public C antMatchers(String ... antPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure antMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.antMatchers(antPatterns));
    }

    @Deprecated
    public abstract C mvcMatchers(String ... var1);

    @Deprecated
    public abstract C mvcMatchers(HttpMethod var1, String ... var2);

    protected final List<MvcRequestMatcher> createMvcMatchers(HttpMethod method, String ... mvcPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure mvcMatchers after anyRequest");
        ObjectPostProcessor opp = (ObjectPostProcessor)this.context.getBean(ObjectPostProcessor.class);
        if (!this.context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
            throw new NoSuchBeanDefinitionException("A Bean named mvcHandlerMappingIntrospector of type " + HandlerMappingIntrospector.class.getName() + " is required to use MvcRequestMatcher. Please ensure Spring Security & Spring MVC are configured in a shared ApplicationContext.");
        }
        HandlerMappingIntrospector introspector = (HandlerMappingIntrospector)this.context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, HandlerMappingIntrospector.class);
        ArrayList<MvcRequestMatcher> matchers = new ArrayList<MvcRequestMatcher>(mvcPatterns.length);
        for (String mvcPattern : mvcPatterns) {
            MvcRequestMatcher matcher = new MvcRequestMatcher(introspector, mvcPattern);
            opp.postProcess(matcher);
            if (method != null) {
                matcher.setMethod(method);
            }
            matchers.add(matcher);
        }
        return matchers;
    }

    @Deprecated
    public C regexMatchers(HttpMethod method, String ... regexPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure regexMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(method, regexPatterns));
    }

    @Deprecated
    public C regexMatchers(String ... regexPatterns) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure regexMatchers after anyRequest");
        return this.chainRequestMatchers(RequestMatchers.regexMatchers(regexPatterns));
    }

    public C dispatcherTypeMatchers(@Nullable HttpMethod method, DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (DispatcherType dispatcherType : dispatcherTypes) {
            matchers.add((RequestMatcher)new DispatcherTypeRequestMatcher(dispatcherType, method));
        }
        return this.chainRequestMatchers(matchers);
    }

    public C dispatcherTypeMatchers(DispatcherType ... dispatcherTypes) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure dispatcherTypeMatchers after anyRequest");
        return this.dispatcherTypeMatchers((HttpMethod)null, dispatcherTypes);
    }

    public C requestMatchers(RequestMatcher ... requestMatchers) {
        Assert.state((!this.anyRequestConfigured ? 1 : 0) != 0, (String)"Can't configure requestMatchers after anyRequest");
        return this.chainRequestMatchers(Arrays.asList(requestMatchers));
    }

    public C requestMatchers(HttpMethod method, String ... patterns) {
        if (!mvcPresent) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        if (!(this.context instanceof WebApplicationContext)) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        WebApplicationContext context = (WebApplicationContext)this.context;
        ServletContext servletContext = context.getServletContext();
        if (servletContext == null) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        Map registrations = servletContext.getServletRegistrations();
        if (registrations == null) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        if (!this.hasDispatcherServlet(registrations)) {
            return this.requestMatchers(RequestMatchers.antMatchersAsArray(method, patterns));
        }
        Assert.isTrue((registrations.size() == 1 ? 1 : 0) != 0, (String)"This method cannot decide whether these patterns are Spring MVC patterns or not. If this endpoint is a Spring MVC endpoint, please use requestMatchers(MvcRequestMatcher); otherwise, please use requestMatchers(AntPathRequestMatcher).");
        return this.requestMatchers(this.createMvcMatchers(method, patterns).toArray(new RequestMatcher[0]));
    }

    private boolean hasDispatcherServlet(Map<String, ? extends ServletRegistration> registrations) {
        if (registrations == null) {
            return false;
        }
        Class dispatcherServlet = ClassUtils.resolveClassName((String)"org.springframework.web.servlet.DispatcherServlet", null);
        for (ServletRegistration servletRegistration : registrations.values()) {
            try {
                Class<?> clazz = Class.forName(servletRegistration.getClassName());
                if (!dispatcherServlet.isAssignableFrom(clazz)) continue;
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        return false;
    }

    public C requestMatchers(String ... patterns) {
        return this.requestMatchers((HttpMethod)null, patterns);
    }

    public C requestMatchers(HttpMethod method) {
        return this.requestMatchers(method, "/**");
    }

    protected abstract C chainRequestMatchers(List<RequestMatcher> var1);

    static {
        ANY_REQUEST = AnyRequestMatcher.INSTANCE;
        mvcPresent = ClassUtils.isPresent((String)HANDLER_MAPPING_INTROSPECTOR, (ClassLoader)AbstractRequestMatcherRegistry.class.getClassLoader());
    }

    private static final class RequestMatchers {
        private RequestMatchers() {
        }

        static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String ... antPatterns) {
            return Arrays.asList(RequestMatchers.antMatchersAsArray(httpMethod, antPatterns));
        }

        static List<RequestMatcher> antMatchers(String ... antPatterns) {
            return RequestMatchers.antMatchers(null, antPatterns);
        }

        static RequestMatcher[] antMatchersAsArray(HttpMethod httpMethod, String ... antPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            RequestMatcher[] matchers = new RequestMatcher[antPatterns.length];
            for (int index = 0; index < antPatterns.length; ++index) {
                matchers[index] = new AntPathRequestMatcher(antPatterns[index], method);
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(HttpMethod httpMethod, String ... regexPatterns) {
            String method = httpMethod != null ? httpMethod.toString() : null;
            ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
            for (String pattern : regexPatterns) {
                matchers.add((RequestMatcher)new RegexRequestMatcher(pattern, method));
            }
            return matchers;
        }

        static List<RequestMatcher> regexMatchers(String ... regexPatterns) {
            return RequestMatchers.regexMatchers(null, regexPatterns);
        }
    }
}

