/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.ContentSecurityPolicyHeaderWriter;
import org.springframework.security.web.header.writers.FeaturePolicyHeaderWriter;
import org.springframework.security.web.header.writers.HpkpHeaderWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.security.web.header.writers.XContentTypeOptionsHeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.RegExpAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.StaticAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.WhiteListedAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HeadersBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_DISABLED = "disabled";
    private static final String ATT_ENABLED = "enabled";
    private static final String ATT_BLOCK = "block";
    private static final String ATT_POLICY = "policy";
    private static final String ATT_STRATEGY = "strategy";
    private static final String ATT_FROM_PARAMETER = "from-parameter";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";
    private static final String ATT_REF = "ref";
    private static final String ATT_INCLUDE_SUBDOMAINS = "include-subdomains";
    private static final String ATT_MAX_AGE_SECONDS = "max-age-seconds";
    private static final String ATT_REQUEST_MATCHER_REF = "request-matcher-ref";
    private static final String ATT_PRELOAD = "preload";
    private static final String ATT_REPORT_ONLY = "report-only";
    private static final String ATT_REPORT_URI = "report-uri";
    private static final String ATT_ALGORITHM = "algorithm";
    private static final String ATT_POLICY_DIRECTIVES = "policy-directives";
    private static final String CACHE_CONTROL_ELEMENT = "cache-control";
    private static final String HPKP_ELEMENT = "hpkp";
    private static final String PINS_ELEMENT = "pins";
    private static final String HSTS_ELEMENT = "hsts";
    private static final String XSS_ELEMENT = "xss-protection";
    private static final String CONTENT_TYPE_ELEMENT = "content-type-options";
    private static final String FRAME_OPTIONS_ELEMENT = "frame-options";
    private static final String GENERIC_HEADER_ELEMENT = "header";
    private static final String CONTENT_SECURITY_POLICY_ELEMENT = "content-security-policy";
    private static final String REFERRER_POLICY_ELEMENT = "referrer-policy";
    private static final String FEATURE_POLICY_ELEMENT = "feature-policy";
    private static final String ALLOW_FROM = "ALLOW-FROM";
    private ManagedList<BeanMetadataElement> headerWriters;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.headerWriters = new ManagedList();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(HeaderWriterFilter.class);
        boolean disabled = element != null && "true".equals(this.resolveAttribute(parserContext, element, ATT_DISABLED));
        boolean defaultsDisabled = element != null && "true".equals(this.resolveAttribute(parserContext, element, "defaults-disabled"));
        boolean addIfNotPresent = element == null || !disabled && !defaultsDisabled;
        this.parseCacheControlElement(addIfNotPresent, element);
        this.parseHstsElement(addIfNotPresent, element, parserContext);
        this.parseXssElement(addIfNotPresent, element, parserContext);
        this.parseFrameOptionsElement(addIfNotPresent, element, parserContext);
        this.parseContentTypeOptionsElement(addIfNotPresent, element);
        this.parseHpkpElement(element == null || !disabled, element, parserContext);
        this.parseContentSecurityPolicyElement(disabled, element, parserContext);
        this.parseReferrerPolicyElement(element, parserContext);
        this.parseFeaturePolicyElement(element, parserContext);
        this.parseHeaderElements(element);
        boolean noWriters = this.headerWriters.isEmpty();
        if (disabled && !noWriters) {
            parserContext.getReaderContext().error("Cannot specify <headers disabled=\"true\"> with child elements.", (Object)element);
        } else if (noWriters) {
            return null;
        }
        builder.addConstructorArgValue(this.headerWriters);
        return builder.getBeanDefinition();
    }

    private String resolveAttribute(ParserContext pc, Element element, String attributeName) {
        return pc.getReaderContext().getEnvironment().resolvePlaceholders(element.getAttribute(attributeName));
    }

    private void parseCacheControlElement(boolean addIfNotPresent, Element element) {
        Element cacheControlElement = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)CACHE_CONTROL_ELEMENT) : null;
        boolean disabled = "true".equals(this.getAttribute(cacheControlElement, ATT_DISABLED, "false"));
        if (disabled) {
            return;
        }
        if (addIfNotPresent || cacheControlElement != null) {
            this.addCacheControl();
        }
    }

    private void addCacheControl() {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(CacheControlHeadersWriter.class);
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void parseHstsElement(boolean addIfNotPresent, Element element, ParserContext context) {
        Element hstsElement;
        Element element2 = hstsElement = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)HSTS_ELEMENT) : null;
        if (addIfNotPresent || hstsElement != null) {
            this.addHsts(addIfNotPresent, hstsElement, context);
        }
    }

    private void addHsts(boolean addIfNotPresent, Element hstsElement, ParserContext context) {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(HstsHeaderWriter.class);
        if (hstsElement != null) {
            String preload;
            String requestMatcherRef;
            String maxAgeSeconds;
            boolean disabled = "true".equals(this.getAttribute(hstsElement, ATT_DISABLED, "false"));
            String includeSubDomains = hstsElement.getAttribute(ATT_INCLUDE_SUBDOMAINS);
            if (StringUtils.hasText((String)includeSubDomains)) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_INCLUDE_SUBDOMAINS, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyValue("includeSubDomains", (Object)includeSubDomains);
            }
            if (StringUtils.hasText((String)(maxAgeSeconds = hstsElement.getAttribute(ATT_MAX_AGE_SECONDS)))) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_MAX_AGE_SECONDS, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyValue("maxAgeInSeconds", (Object)maxAgeSeconds);
            }
            if (StringUtils.hasText((String)(requestMatcherRef = hstsElement.getAttribute(ATT_REQUEST_MATCHER_REF)))) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_REQUEST_MATCHER_REF, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyReference("requestMatcher", requestMatcherRef);
            }
            if (StringUtils.hasText((String)(preload = hstsElement.getAttribute(ATT_PRELOAD)))) {
                if (disabled) {
                    this.attrNotAllowed(context, ATT_PRELOAD, ATT_DISABLED, hstsElement);
                }
                headersWriter.addPropertyValue(ATT_PRELOAD, (Object)preload);
            }
            if (disabled) {
                return;
            }
        }
        if (addIfNotPresent || hstsElement != null) {
            this.headerWriters.add((Object)headersWriter.getBeanDefinition());
        }
    }

    private void parseHpkpElement(boolean addIfNotPresent, Element element, ParserContext context) {
        Element hpkpElement;
        Element element2 = hpkpElement = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)HPKP_ELEMENT) : null;
        if (addIfNotPresent || hpkpElement != null) {
            this.addHpkp(addIfNotPresent, hpkpElement, context);
        }
    }

    private void addHpkp(boolean addIfNotPresent, Element hpkpElement, ParserContext context) {
        if (hpkpElement != null) {
            String reportUri;
            String reportOnly;
            String maxAgeSeconds;
            String includeSubDomains;
            boolean disabled = "true".equals(this.getAttribute(hpkpElement, ATT_DISABLED, "false"));
            if (disabled) {
                return;
            }
            BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(HpkpHeaderWriter.class);
            Element pinsElement = DomUtils.getChildElementByTagName((Element)hpkpElement, (String)PINS_ELEMENT);
            if (pinsElement != null) {
                List pinElements = DomUtils.getChildElements((Element)pinsElement);
                LinkedHashMap<String, String> pins = new LinkedHashMap<String, String>();
                for (Element pinElement : pinElements) {
                    Node pinValueNode;
                    String hash = pinElement.getAttribute(ATT_ALGORITHM);
                    if (!StringUtils.hasText((String)hash)) {
                        hash = "sha256";
                    }
                    if ((pinValueNode = pinElement.getFirstChild()) == null) {
                        context.getReaderContext().warning("Missing value for pin entry.", (Object)hpkpElement);
                        continue;
                    }
                    String fingerprint = pinElement.getFirstChild().getTextContent();
                    pins.put(fingerprint, hash);
                }
                headersWriter.addPropertyValue(PINS_ELEMENT, pins);
            }
            if (StringUtils.hasText((String)(includeSubDomains = hpkpElement.getAttribute(ATT_INCLUDE_SUBDOMAINS)))) {
                headersWriter.addPropertyValue("includeSubDomains", (Object)includeSubDomains);
            }
            if (StringUtils.hasText((String)(maxAgeSeconds = hpkpElement.getAttribute(ATT_MAX_AGE_SECONDS)))) {
                headersWriter.addPropertyValue("maxAgeInSeconds", (Object)maxAgeSeconds);
            }
            if (StringUtils.hasText((String)(reportOnly = hpkpElement.getAttribute(ATT_REPORT_ONLY)))) {
                headersWriter.addPropertyValue("reportOnly", (Object)reportOnly);
            }
            if (StringUtils.hasText((String)(reportUri = hpkpElement.getAttribute(ATT_REPORT_URI)))) {
                headersWriter.addPropertyValue("reportUri", (Object)reportUri);
            }
            if (addIfNotPresent) {
                this.headerWriters.add((Object)headersWriter.getBeanDefinition());
            }
        }
    }

    private void parseContentSecurityPolicyElement(boolean elementDisabled, Element element, ParserContext context) {
        Element contentSecurityPolicyElement;
        Element element2 = contentSecurityPolicyElement = elementDisabled || element == null ? null : DomUtils.getChildElementByTagName((Element)element, (String)CONTENT_SECURITY_POLICY_ELEMENT);
        if (contentSecurityPolicyElement != null) {
            this.addContentSecurityPolicy(contentSecurityPolicyElement, context);
        }
    }

    private void addContentSecurityPolicy(Element contentSecurityPolicyElement, ParserContext context) {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(ContentSecurityPolicyHeaderWriter.class);
        String policyDirectives = contentSecurityPolicyElement.getAttribute(ATT_POLICY_DIRECTIVES);
        if (!StringUtils.hasText((String)policyDirectives)) {
            context.getReaderContext().error("policy-directives requires a 'value' to be set.", (Object)contentSecurityPolicyElement);
        } else {
            headersWriter.addConstructorArgValue((Object)policyDirectives);
        }
        String reportOnly = contentSecurityPolicyElement.getAttribute(ATT_REPORT_ONLY);
        if (StringUtils.hasText((String)reportOnly)) {
            headersWriter.addPropertyValue("reportOnly", (Object)reportOnly);
        }
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void parseReferrerPolicyElement(Element element, ParserContext context) {
        Element referrerPolicyElement;
        Element element2 = referrerPolicyElement = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)REFERRER_POLICY_ELEMENT) : null;
        if (referrerPolicyElement != null) {
            this.addReferrerPolicy(referrerPolicyElement, context);
        }
    }

    private void addReferrerPolicy(Element referrerPolicyElement, ParserContext context) {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(ReferrerPolicyHeaderWriter.class);
        String policy = referrerPolicyElement.getAttribute(ATT_POLICY);
        if (StringUtils.hasLength((String)policy)) {
            headersWriter.addConstructorArgValue((Object)ReferrerPolicyHeaderWriter.ReferrerPolicy.get((String)policy));
        }
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void parseFeaturePolicyElement(Element element, ParserContext context) {
        Element featurePolicyElement;
        Element element2 = featurePolicyElement = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)FEATURE_POLICY_ELEMENT) : null;
        if (featurePolicyElement != null) {
            this.addFeaturePolicy(featurePolicyElement, context);
        }
    }

    private void addFeaturePolicy(Element featurePolicyElement, ParserContext context) {
        BeanDefinitionBuilder headersWriter = BeanDefinitionBuilder.genericBeanDefinition(FeaturePolicyHeaderWriter.class);
        String policyDirectives = featurePolicyElement.getAttribute(ATT_POLICY_DIRECTIVES);
        if (!StringUtils.hasText((String)policyDirectives)) {
            context.getReaderContext().error("policy-directives requires a 'value' to be set.", (Object)featurePolicyElement);
        } else {
            headersWriter.addConstructorArgValue((Object)policyDirectives);
        }
        this.headerWriters.add((Object)headersWriter.getBeanDefinition());
    }

    private void attrNotAllowed(ParserContext context, String attrName, String otherAttrName, Element element) {
        context.getReaderContext().error("Only one of '" + attrName + "' or '" + otherAttrName + "' can be set.", (Object)element);
    }

    private void parseHeaderElements(Element element) {
        List headerElts = element != null ? DomUtils.getChildElementsByTagName((Element)element, (String)GENERIC_HEADER_ELEMENT) : Collections.emptyList();
        for (Element headerElt : headerElts) {
            String headerFactoryRef = headerElt.getAttribute(ATT_REF);
            if (StringUtils.hasText((String)headerFactoryRef)) {
                this.headerWriters.add((Object)new RuntimeBeanReference(headerFactoryRef));
                continue;
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticHeadersWriter.class);
            builder.addConstructorArgValue((Object)headerElt.getAttribute(ATT_NAME));
            builder.addConstructorArgValue((Object)headerElt.getAttribute(ATT_VALUE));
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private void parseContentTypeOptionsElement(boolean addIfNotPresent, Element element) {
        Element contentTypeElt = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)CONTENT_TYPE_ELEMENT) : null;
        boolean disabled = "true".equals(this.getAttribute(contentTypeElt, ATT_DISABLED, "false"));
        if (disabled) {
            return;
        }
        if (addIfNotPresent || contentTypeElt != null) {
            this.addContentTypeOptions();
        }
    }

    private void addContentTypeOptions() {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XContentTypeOptionsHeaderWriter.class);
        this.headerWriters.add((Object)builder.getBeanDefinition());
    }

    private void parseFrameOptionsElement(boolean addIfNotPresent, Element element, ParserContext parserContext) {
        Element frameElement;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XFrameOptionsHeaderWriter.class);
        Element element2 = frameElement = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)FRAME_OPTIONS_ELEMENT) : null;
        if (frameElement == null) {
            if (addIfNotPresent) {
                this.headerWriters.add((Object)builder.getBeanDefinition());
            }
            return;
        }
        String header = this.getAttribute(frameElement, ATT_POLICY, null);
        boolean disabled = "true".equals(this.getAttribute(frameElement, ATT_DISABLED, "false"));
        if (disabled && header != null) {
            this.attrNotAllowed(parserContext, ATT_DISABLED, ATT_POLICY, frameElement);
        }
        String string = header = StringUtils.hasText((String)header) ? header : "DENY";
        if (ALLOW_FROM.equals(header)) {
            this.parseAllowFromFrameOptionsElement(parserContext, builder, frameElement);
        } else {
            builder.addConstructorArgValue((Object)header);
        }
        if (!disabled) {
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private void parseAllowFromFrameOptionsElement(ParserContext parserContext, BeanDefinitionBuilder builder, Element frameElement) {
        String strategyRef = this.getAttribute(frameElement, ATT_REF, null);
        String strategy = this.getAttribute(frameElement, ATT_STRATEGY, null);
        if (StringUtils.hasText((String)strategy) && StringUtils.hasText((String)strategyRef)) {
            parserContext.getReaderContext().error("Only one of 'strategy' or 'strategy-ref' can be set.", (Object)frameElement);
            return;
        }
        if (strategyRef != null) {
            builder.addConstructorArgReference(strategyRef);
            return;
        }
        if (strategy == null) {
            parserContext.getReaderContext().error("One of 'strategy' and 'strategy-ref' must be set.", (Object)frameElement);
            return;
        }
        String value = this.getAttribute(frameElement, ATT_VALUE, null);
        if (!StringUtils.hasText((String)value)) {
            parserContext.getReaderContext().error("Strategy requires a 'value' to be set.", (Object)frameElement);
            return;
        }
        if ("static".equals(strategy)) {
            try {
                builder.addConstructorArgValue((Object)new StaticAllowFromStrategy(new URI(value)));
            }
            catch (URISyntaxException ex) {
                parserContext.getReaderContext().error("'value' attribute doesn't represent a valid URI.", (Object)frameElement, (Throwable)ex);
            }
            return;
        }
        BeanDefinitionBuilder allowFromStrategy = this.getAllowFromStrategy(strategy, value);
        String fromParameter = this.getAttribute(frameElement, ATT_FROM_PARAMETER, "from");
        allowFromStrategy.addPropertyValue("allowFromParameterName", (Object)fromParameter);
        builder.addConstructorArgValue((Object)allowFromStrategy.getBeanDefinition());
    }

    private BeanDefinitionBuilder getAllowFromStrategy(String strategy, String value) {
        if ("whitelist".equals(strategy)) {
            BeanDefinitionBuilder allowFromStrategy = BeanDefinitionBuilder.rootBeanDefinition(WhiteListedAllowFromStrategy.class);
            allowFromStrategy.addConstructorArgValue((Object)StringUtils.commaDelimitedListToSet((String)value));
            return allowFromStrategy;
        }
        BeanDefinitionBuilder allowFromStrategy = BeanDefinitionBuilder.rootBeanDefinition(RegExpAllowFromStrategy.class);
        allowFromStrategy.addConstructorArgValue((Object)value);
        return allowFromStrategy;
    }

    private void parseXssElement(boolean addIfNotPresent, Element element, ParserContext parserContext) {
        Element xssElt = element != null ? DomUtils.getChildElementByTagName((Element)element, (String)XSS_ELEMENT) : null;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XXssProtectionHeaderWriter.class);
        if (xssElt != null) {
            String block;
            boolean disabled = "true".equals(this.getAttribute(xssElt, ATT_DISABLED, "false"));
            String enabled = xssElt.getAttribute(ATT_ENABLED);
            if (StringUtils.hasText((String)enabled)) {
                if (disabled) {
                    this.attrNotAllowed(parserContext, ATT_ENABLED, ATT_DISABLED, xssElt);
                }
                builder.addPropertyValue(ATT_ENABLED, (Object)enabled);
            }
            if (StringUtils.hasText((String)(block = xssElt.getAttribute(ATT_BLOCK)))) {
                if (disabled) {
                    this.attrNotAllowed(parserContext, ATT_BLOCK, ATT_DISABLED, xssElt);
                }
                builder.addPropertyValue(ATT_BLOCK, (Object)block);
            }
            if (disabled) {
                return;
            }
        }
        if (addIfNotPresent || xssElt != null) {
            this.headerWriters.add((Object)builder.getBeanDefinition());
        }
    }

    private String getAttribute(Element element, String name, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(name);
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return defaultValue;
    }
}

