/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.typeconversion.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.ldap.odm.typeconversion.impl.Converter;
import org.springframework.ldap.odm.typeconversion.impl.ConverterManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConverterManagerFactoryBean
implements FactoryBean {
    private static Log LOG = LogFactory.getLog(ConverterManagerFactoryBean.class);
    private Set<ConverterConfig> converterConfigList = null;

    public void setConverterConfig(Set<ConverterConfig> converterConfigList) {
        this.converterConfigList = converterConfigList;
    }

    public Object getObject() throws Exception {
        if (this.converterConfigList == null) {
            throw new FactoryBeanNotInitializedException("converterConfigList has not been set");
        }
        ConverterManagerImpl result = new ConverterManagerImpl();
        for (ConverterConfig converterConfig : this.converterConfigList) {
            if (converterConfig.fromClasses == null || converterConfig.toClasses == null || converterConfig.converter == null) {
                throw new FactoryBeanNotInitializedException(String.format("All of fromClasses, toClasses and converter must be specified in bean %1$s", converterConfig.toString()));
            }
            for (Class fromClass : converterConfig.fromClasses) {
                for (Class toClass : converterConfig.toClasses) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Adding converter from %1$s to %2$s", fromClass, toClass));
                    }
                    result.addConverter(fromClass, converterConfig.syntax, toClass, converterConfig.converter);
                }
            }
        }
        return result;
    }

    public Class<?> getObjectType() {
        return ConverterManagerImpl.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConverterConfig {
        private Set<Class<?>> fromClasses = new HashSet();
        private String syntax = null;
        private Set<Class<?>> toClasses = new HashSet();
        private Converter converter = null;

        public void setFromClasses(Set<Class<?>> fromClasses) {
            this.fromClasses = fromClasses;
        }

        public void setToClasses(Set<Class<?>> toClasses) {
            this.toClasses = toClasses;
        }

        public void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public String toString() {
            return String.format("fromClasses=%1$s, syntax=%2$s, toClasses=%3$s, converter=%4$s", this.fromClasses, this.syntax, this.toClasses, this.converter);
        }
    }
}

