/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ErrorHandlingDeserializer
implements ExtendedDeserializer<Object> {
    public static final String KEY_DESERIALIZER_CLASS = "spring.deserializer.key.delegate.class";
    public static final String VALUE_DESERIALIZER_CLASS = "spring.deserializer.value.delegate.class";
    private ExtendedDeserializer<Object> delegate;
    private boolean isKey;

    public ErrorHandlingDeserializer() {
    }

    public ErrorHandlingDeserializer(ExtendedDeserializer<Object> delegate) {
        this.delegate = delegate;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (isKey && configs.containsKey(KEY_DESERIALIZER_CLASS)) {
            try {
                Object value = configs.get(KEY_DESERIALIZER_CLASS);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                this.delegate = (ExtendedDeserializer)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
        if (!isKey && configs.containsKey(VALUE_DESERIALIZER_CLASS)) {
            try {
                Object value = configs.get(VALUE_DESERIALIZER_CLASS);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                this.delegate = (ExtendedDeserializer)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"No delegate deserializer configured");
        this.delegate.configure(configs, isKey);
        this.isKey = isKey;
    }

    public Object deserialize(String topic, byte[] data) {
        try {
            return this.delegate.deserialize(topic, data);
        }
        catch (Exception e) {
            return new DeserializationException("Failed to deserialize", data, this.isKey, e);
        }
    }

    public void close() {
        this.delegate.close();
    }

    public Object deserialize(String topic, Headers headers, byte[] data) {
        try {
            return this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception e) {
            return new DeserializationException("Failed to deserialize", data, this.isKey, e);
        }
    }
}

