/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.tail;

import java.io.File;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.file.event.FileIntegrationEvent;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class FileTailingMessageProducerSupport
extends MessageProducerSupport
implements ApplicationEventPublisherAware {
    private volatile File file;
    private volatile ApplicationEventPublisher eventPublisher;
    private volatile TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private volatile long tailAttemptsDelay = 5000L;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setFile(File file) {
        Assert.notNull((Object)file, (String)"'file' cannot be null");
        this.file = file;
    }

    protected File getFile() {
        if (this.file == null) {
            throw new IllegalStateException("No 'file' has been provided");
        }
        return this.file;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' cannot be null");
        this.taskExecutor = taskExecutor;
    }

    public void setTailAttemptsDelay(long tailAttemptsDelay) {
        Assert.isTrue((tailAttemptsDelay > 0L ? 1 : 0) != 0, (String)"'tailAttemptsDelay' must be > 0");
        this.tailAttemptsDelay = tailAttemptsDelay;
    }

    protected long getMissingFileDelay() {
        return this.tailAttemptsDelay;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public String getComponentType() {
        return "file:tail-inbound-channel-adapter";
    }

    protected void send(String line) {
        Message message = this.getMessageBuilderFactory().withPayload((Object)line).setHeader("file_name", (Object)this.file.getAbsolutePath()).build();
        super.sendMessage(message);
    }

    protected void publish(String message) {
        if (this.eventPublisher != null) {
            FileTailingEvent event = new FileTailingEvent((Object)this, message, this.file);
            this.eventPublisher.publishEvent((ApplicationEvent)event);
        } else {
            this.logger.info((Object)("No publisher for event:" + message));
        }
    }

    public static class FileTailingEvent
    extends FileIntegrationEvent {
        private static final long serialVersionUID = -3382255736225946206L;
        private final String message;
        private final File file;

        public FileTailingEvent(Object source, String message, File file) {
            super(source);
            this.message = message;
            this.file = file;
        }

        protected String getMessage() {
            return this.message;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return "FileTailingEvent " + super.toString() + " [message=" + this.message + ", file=" + this.file.getAbsolutePath() + "]";
        }
    }
}

