/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.config.FileParserUtils;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.synchronizer.InboundFileSynchronizer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractRemoteFileInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected final BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder synchronizerBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getInboundFileSynchronizerClass());
        synchronizerBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"remote-directory", (String)"remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (expressionDef != null) {
            synchronizerBuilder.addPropertyValue("remoteDirectoryExpression", (Object)expressionDef);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)synchronizerBuilder, (Element)element, (String)"delete-remote-files");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)synchronizerBuilder, (Element)element, (String)"preserve-timestamp");
        String remoteFileSeparator = element.getAttribute("remote-file-separator");
        synchronizerBuilder.addPropertyValue("remoteFileSeparator", (Object)remoteFileSeparator);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)synchronizerBuilder, (Element)element, (String)"temporary-file-suffix");
        FileParserUtils.configureFilter(synchronizerBuilder, element, parserContext, this.getSimplePatternFileListFilterClass(), this.getRegexPatternFileListFilterClass());
        BeanDefinitionBuilder messageSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getMessageSourceClassname());
        messageSourceBuilder.addConstructorArgValue((Object)synchronizerBuilder.getBeanDefinition());
        String comparator = element.getAttribute("comparator");
        if (StringUtils.hasText((String)comparator)) {
            messageSourceBuilder.addConstructorArgReference(comparator);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)messageSourceBuilder, (Element)element, (String)"local-filter");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)messageSourceBuilder, (Element)element, (String)"local-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)messageSourceBuilder, (Element)element, (String)"auto-create-local-directory");
        String localFileGeneratorExpression = element.getAttribute("local-filename-generator-expression");
        if (StringUtils.hasText((String)localFileGeneratorExpression)) {
            BeanDefinitionBuilder localFileGeneratorExpressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            localFileGeneratorExpressionBuilder.addConstructorArgValue((Object)localFileGeneratorExpression);
            synchronizerBuilder.addPropertyValue("localFilenameGeneratorExpression", (Object)localFileGeneratorExpressionBuilder.getBeanDefinition());
        }
        return messageSourceBuilder.getBeanDefinition();
    }

    protected abstract String getMessageSourceClassname();

    protected abstract Class<? extends InboundFileSynchronizer> getInboundFileSynchronizerClass();

    protected abstract Class<? extends FileListFilter<?>> getSimplePatternFileListFilterClass();

    protected abstract Class<? extends FileListFilter<?>> getRegexPatternFileListFilterClass();
}

