/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import java.util.Optional;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class LinkDiscoverers {
    private final PluginRegistry<LinkDiscoverer, MediaType> discoverers;

    public LinkDiscoverers(PluginRegistry<LinkDiscoverer, MediaType> discoverers) {
        Assert.notNull(discoverers, (String)"Registry of LinkDiscoverer must not be null!");
        this.discoverers = discoverers;
    }

    public Optional<LinkDiscoverer> getLinkDiscovererFor(MediaType mediaType) {
        return this.discoverers.getPluginFor((Object)mediaType);
    }

    public Optional<LinkDiscoverer> getLinkDiscovererFor(String mediaType) {
        return this.getLinkDiscovererFor(MediaType.valueOf((String)mediaType));
    }

    public LinkDiscoverer getRequiredLinkDiscovererFor(MediaType mediaType) {
        return (LinkDiscoverer)this.discoverers.getRequiredPluginFor((Object)mediaType);
    }

    public LinkDiscoverer getRequiredLinkDiscovererFor(String mediaType) {
        return this.getRequiredLinkDiscovererFor(MediaType.valueOf((String)mediaType));
    }
}

