/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.LinkMixin;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsDeserializers;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsSerializers;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.mvc.JacksonSerializers;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;

public class Jackson2HalFormsModule
extends SimpleModule {
    private static final long serialVersionUID = -4496351128468451196L;

    public Jackson2HalFormsModule() {
        super("hal-forms-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(Links.class, LinksMixin.class);
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(EntityModel.class, EntityModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
        this.setMixInAnnotation(PagedModel.class, PagedModelMixin.class);
        this.setMixInAnnotation(MediaType.class, MediaTypeMixin.class);
    }

    public static class HalFormsHandlerInstantiator
    extends Jackson2HalModule.HalHandlerInstantiator {
        private final Map<Class<?>, Object> serializers = new HashMap();

        public HalFormsHandlerInstantiator(LinkRelationProvider resolver, CurieProvider curieProvider, MessageResolver accessor, HalFormsConfiguration configuration, AutowireCapableBeanFactory beanFactory) {
            super(resolver, curieProvider, accessor, configuration.getHalConfiguration(), beanFactory);
            HalConfiguration halConfiguration = configuration.getHalConfiguration();
            Jackson2HalModule.EmbeddedMapper mapper = new Jackson2HalModule.EmbeddedMapper(resolver, curieProvider, halConfiguration.isEnforceEmbeddedCollections());
            HalFormsTemplateBuilder builder = new HalFormsTemplateBuilder(configuration, accessor);
            this.serializers.put(HalFormsSerializers.HalFormsRepresentationModelSerializer.class, (Object)new HalFormsSerializers.HalFormsRepresentationModelSerializer(builder));
            this.serializers.put(HalFormsSerializers.HalFormsEntityModelSerializer.class, (Object)new HalFormsSerializers.HalFormsEntityModelSerializer(builder));
            this.serializers.put(HalFormsSerializers.HalFormsCollectionModelSerializer.class, (Object)new HalFormsSerializers.HalFormsCollectionModelSerializer(builder, mapper, halConfiguration));
            this.serializers.put(Jackson2HalModule.HalLinkListSerializer.class, (Object)new Jackson2HalModule.HalLinkListSerializer(curieProvider, mapper, accessor, halConfiguration));
        }

        public HalFormsHandlerInstantiator(LinkRelationProvider relProvider, CurieProvider curieProvider, MessageResolver resolver, AutowireCapableBeanFactory beanFactory) {
            this(relProvider, curieProvider, resolver, (HalFormsConfiguration)beanFactory.getBean(HalFormsConfiguration.class), beanFactory);
        }

        @Nullable
        private Object findInstance(Class<?> type) {
            return this.serializers.get(type);
        }

        @Override
        public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
            Object jsonDeser = this.findInstance(deserClass);
            return jsonDeser != null ? (JsonDeserializer<?>)jsonDeser : super.deserializerInstance(config, annotated, deserClass);
        }

        @Override
        public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
            Object keyDeser = this.findInstance(keyDeserClass);
            return keyDeser != null ? (KeyDeserializer)keyDeser : super.keyDeserializerInstance(config, annotated, keyDeserClass);
        }

        @Override
        public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
            Object jsonSer = this.findInstance(serClass);
            return jsonSer != null ? (JsonSerializer<?>)jsonSer : super.serializerInstance(config, annotated, serClass);
        }

        @Override
        public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
            Object builder = this.findInstance(builderClass);
            return builder != null ? (TypeResolverBuilder<?>)builder : super.typeResolverBuilderInstance(config, annotated, builderClass);
        }

        @Override
        public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
            Object resolver = this.findInstance(resolverClass);
            return resolver != null ? (TypeIdResolver)resolver : super.typeIdResolverInstance(config, annotated, resolverClass);
        }
    }

    static class HalFormsLinksDeserializer
    extends ContainerDeserializerBase<Links> {
        private static final long serialVersionUID = -848240531474910385L;
        private final Jackson2HalModule.HalLinkListDeserializer delegate = new Jackson2HalModule.HalLinkListDeserializer();

        public HalFormsLinksDeserializer() {
            super(TypeFactory.defaultInstance().constructType(Links.class));
        }

        @Nullable
        public JsonDeserializer<Object> getContentDeserializer() {
            return this.delegate.getContentDeserializer();
        }

        public Links deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Links.of((Iterable<Link>)this.delegate.deserialize(p, ctxt));
        }
    }

    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.MediaTypeDeserializer.class)
    static interface MediaTypeMixin {
    }

    abstract class PagedModelMixin<T>
    extends PagedModel<T> {
        PagedModelMixin() {
        }

        @Override
        @Nullable
        @JsonProperty(value="page")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public PagedModel.PageMetadata getMetadata() {
            return super.getMetadata();
        }
    }

    @JsonSerialize(using=HalFormsSerializers.HalFormsCollectionModelSerializer.class)
    abstract class CollectionModelMixin<T>
    extends CollectionModel<T> {
        CollectionModelMixin() {
        }

        @Override
        @JsonProperty(value="_embedded")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonDeserialize(using=HalFormsDeserializers.HalFormsCollectionModelDeserializer.class)
        public abstract Collection<T> getContent();
    }

    @JsonSerialize(using=HalFormsSerializers.HalFormsEntityModelSerializer.class)
    abstract class EntityModelMixin<T>
    extends EntityModel<T> {
        EntityModelMixin() {
        }
    }

    @JsonSerialize(using=HalFormsSerializers.HalFormsRepresentationModelSerializer.class)
    abstract class RepresentationModelMixin
    extends org.springframework.hateoas.mediatype.hal.RepresentationModelMixin {
        RepresentationModelMixin() {
        }
    }

    @JsonSerialize(using=Jackson2HalModule.HalLinkListSerializer.class)
    abstract class LinksMixin {
        LinksMixin() {
        }
    }
}

