/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.pdx;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.gemfire.mapping.MappingPdxSerializer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class MappingPdxSerializerIncludedTypesRegistrar
implements BeanPostProcessor {
    private final Class<?>[] types;

    @NonNull
    public static MappingPdxSerializerIncludedTypesRegistrar with(Class<?> ... types) {
        return new MappingPdxSerializerIncludedTypesRegistrar(types);
    }

    public MappingPdxSerializerIncludedTypesRegistrar(@NonNull Class<?>[] types) {
        this.types = (Class[])Arrays.stream(ArrayUtils.nullSafeArray((Object[])types, Class.class)).filter(Objects::nonNull).toArray(Class[]::new);
    }

    @NonNull
    protected Class<?>[] getTypes() {
        return this.types;
    }

    protected Optional<Predicate<Class<?>>> getCompositeIncludeTypeFilter() {
        Predicate<Class<?>> compositeIncludeTypeFilter = null;
        for (Class<?> type : this.getTypes()) {
            if (type == null) continue;
            compositeIncludeTypeFilter = compositeIncludeTypeFilter != null ? compositeIncludeTypeFilter.or(this.newIncludeTypeFilter(type)) : this.newIncludeTypeFilter(type);
        }
        return Optional.ofNullable(compositeIncludeTypeFilter);
    }

    @Nullable
    protected Predicate<Class<?>> newIncludeTypeFilter(@Nullable Class<?> type) {
        return type != null ? testType -> Objects.nonNull(testType) && type.isAssignableFrom((Class<?>)testType) : null;
    }

    @Nullable
    public Object postProcessAfterInitialization(@Nullable Object bean, @Nullable String beanName) throws BeansException {
        GemFireCache cache;
        PdxSerializer pdxSerializer;
        if (bean instanceof GemFireCache && (pdxSerializer = (cache = (GemFireCache)bean).getPdxSerializer()) instanceof MappingPdxSerializer) {
            MappingPdxSerializer mappingPdxSerializer = (MappingPdxSerializer)pdxSerializer;
            this.getCompositeIncludeTypeFilter().ifPresent(arg_0 -> ((MappingPdxSerializer)mappingPdxSerializer).setIncludeTypeFilters(arg_0));
        }
        return bean;
    }
}

