/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.jackson.databind.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.springframework.data.gemfire.util.CollectionUtils;

public class TypelessCollectionSerializer
extends AsArraySerializerBase<Collection<?>> {
    protected static final boolean DEFAULT_UNWRAP_SINGLE = false;
    protected static final boolean DEFAULT_STATIC_TYPING = false;

    public TypelessCollectionSerializer(ObjectMapper mapper) {
        super(Collection.class, mapper.getTypeFactory().constructType(Object.class), false, null, null);
    }

    public TypelessCollectionSerializer(TypelessCollectionSerializer serializer, BeanProperty property, TypeSerializer typeSerializer, JsonSerializer<?> elementSerializer) {
        super((AsArraySerializerBase)serializer, property, typeSerializer, elementSerializer, Boolean.valueOf(false));
    }

    public void serializeWithType(Collection<?> value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(value, jsonGenerator, serializerProvider);
    }

    public boolean hasSingleElement(Collection<?> value) {
        return value != null && value.size() == 1;
    }

    protected void serializeContents(Collection<?> value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.setCurrentValue(value);
        PropertySerializerMap serializers = this._dynamicSerializers;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        int index = -1;
        try {
            for (Object element : CollectionUtils.nullSafeCollection(value)) {
                ++index;
                if (Objects.isNull(element)) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> elementType = element.getClass();
                JsonSerializer<Object> serializer = this.resolveSerializer(serializerProvider, elementType);
                if (typeSerializer != null) {
                    serializer.serializeWithType(element, jsonGenerator, serializerProvider, typeSerializer);
                    continue;
                }
                serializer.serialize(element, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception cause) {
            this.wrapAndThrow(serializerProvider, cause, value, index);
        }
    }

    private JavaType constructSpecializedType(SerializerProvider serializerProvider, JavaType baseType, Class<?> subclass) {
        return serializerProvider.constructSpecializedType(baseType, subclass);
    }

    private JsonSerializer<Object> resolveSerializer(SerializerProvider serializerProvider, Class<?> type) throws JsonMappingException {
        PropertySerializerMap dynamicSerializers;
        JsonSerializer resolvedSerializer = this._elementSerializer;
        if (Objects.isNull(resolvedSerializer) && Objects.isNull(resolvedSerializer = (dynamicSerializers = this._dynamicSerializers).serializerFor(type))) {
            resolvedSerializer = Objects.nonNull(this._elementType) && this._elementType.hasGenericTypes() ? this._findAndAddDynamic(dynamicSerializers, this.constructSpecializedType(serializerProvider, this._elementType, type), serializerProvider) : this._findAndAddDynamic(dynamicSerializers, type, serializerProvider);
        }
        return resolvedSerializer;
    }

    public TypelessCollectionSerializer withResolved(BeanProperty property, TypeSerializer typeSerializer, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new TypelessCollectionSerializer(this, property, typeSerializer, elementSerializer);
    }

    public TypelessCollectionSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new TypelessCollectionSerializer(this, this._property, typeSerializer, this._elementSerializer);
    }
}

