/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.distributed.event;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.geode.distributed.event.MembershipListenerAdapter;
import org.springframework.geode.distributed.event.support.MemberDepartedEvent;
import org.springframework.geode.distributed.event.support.MemberJoinedEvent;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class ApplicationContextMembershipListener
extends MembershipListenerAdapter<ApplicationContextMembershipListener> {
    private final ConfigurableApplicationContext applicationContext;

    public ApplicationContextMembershipListener(@NonNull ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ConfigurableApplicationContext must not be null");
        this.applicationContext = applicationContext;
    }

    @NonNull
    protected ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void handleMemberDeparted(MemberDepartedEvent event) {
        this.getApplicationContext().close();
    }

    public void handleMemberJoined(MemberJoinedEvent event) {
        this.getApplicationContext().refresh();
    }
}

