/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.support;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.geode.cache.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.geode.core.env.EnvironmentMapAdapter;
import org.springframework.geode.core.io.ResourceReader;
import org.springframework.geode.core.io.ResourceResolver;
import org.springframework.geode.core.io.ResourceWriter;
import org.springframework.geode.core.io.support.ByteArrayResourceReader;
import org.springframework.geode.core.io.support.FileResourceWriter;
import org.springframework.geode.core.io.support.ResourceLoaderResourceResolver;
import org.springframework.geode.core.io.support.ResourcePrefix;
import org.springframework.geode.core.io.support.ResourceUtils;
import org.springframework.geode.core.util.ObjectAwareUtils;
import org.springframework.geode.core.util.ObjectUtils;
import org.springframework.geode.data.AbstractCacheDataImporterExporter;
import org.springframework.geode.expression.SmartEnvironmentAccessor;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class ResourceCapableCacheDataImporterExporter
extends AbstractCacheDataImporterExporter
implements InitializingBean,
ResourceLoaderAware {
    protected static final String CACHE_DATA_EXPORT_RESOURCE_LOCATION_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.export.resource.location";
    protected static final String CACHE_DATA_IMPORT_RESOURCE_LOCATION_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.import.resource.location";
    protected static final String RESOURCE_NAME_PATTERN = "data-%s.json";
    private ExportResourceResolver exportResourceResolver;
    private ImportResourceResolver importResourceResolver;
    private ResourceLoader resourceLoader;
    private ResourceReader resourceReader;
    private ResourceWriter resourceWriter;

    public void afterPropertiesSet() {
        this.setExportResourceResolver(ObjectUtils.initialize(this.getExportResourceResolver(), FileSystemExportResourceResolver::new));
        this.setImportResourceResolver(ObjectUtils.initialize(this.getImportResourceResolver(), ClassPathImportResourceResolver::new));
        this.setResourceReader(ObjectUtils.initialize(this.getResourceReader(), ByteArrayResourceReader::new));
        this.setResourceWriter(ObjectUtils.initialize(this.getResourceWriter(), FileResourceWriter::new));
        Stream.of(this.getExportResourceResolver(), this.getImportResourceResolver()).forEach(this.newCompositeObjectAwareInitializer());
    }

    Consumer<Object> newCompositeObjectAwareInitializer() {
        return ObjectAwareUtils.applicationContextAwareObjectInitializer(this.getApplicationContext().orElse(null)).andThen(ObjectAwareUtils.environmentAwareObjectInitializer(this.getEnvironment().orElse(null))).andThen(ObjectAwareUtils.resourceLoaderAwareObjectInitializer(this.getResourceLoader().orElse(null)));
    }

    @Autowired(required=false)
    public void setExportResourceResolver(@Nullable ExportResourceResolver exportResourceResolver) {
        this.exportResourceResolver = exportResourceResolver;
    }

    @NonNull
    protected ExportResourceResolver getExportResourceResolver() {
        return this.exportResourceResolver;
    }

    @Autowired(required=false)
    public void setImportResourceResolver(@Nullable ImportResourceResolver importResourceResolver) {
        this.importResourceResolver = importResourceResolver;
    }

    @NonNull
    protected ImportResourceResolver getImportResourceResolver() {
        return this.importResourceResolver;
    }

    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Optional<ResourceLoader> getResourceLoader() {
        return Optional.ofNullable(this.resourceLoader);
    }

    @Autowired(required=false)
    public void setResourceReader(@Nullable ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    @NonNull
    protected ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    @Autowired(required=false)
    public void setResourceWriter(@Nullable ResourceWriter resourceWriter) {
        this.resourceWriter = resourceWriter;
    }

    @NonNull
    protected ResourceWriter getResourceWriter() {
        return this.resourceWriter;
    }

    public static class ClassPathImportResourceResolver
    extends AbstractImportResourceResolver {
        @Override
        @NonNull
        protected String getResourcePath() {
            return ResourcePrefix.CLASSPATH_URL_PREFIX.toUrlPrefix();
        }
    }

    public static abstract class AbstractImportResourceResolver
    extends AbstractCacheResourceResolver
    implements ImportResourceResolver {
        @Override
        public Optional<Resource> resolve(@NonNull Region<?, ?> region) {
            boolean readable;
            Assert.notNull(region, (String)"Region must not be null");
            String resourceLocation = this.getResourceLocation(region, ResourceCapableCacheDataImporterExporter.CACHE_DATA_IMPORT_RESOURCE_LOCATION_PROPERTY_NAME);
            Optional<Resource> resource = this.resolve(resourceLocation);
            boolean exists = resource.isPresent();
            boolean bl = readable = exists && resource.filter(Resource::isReadable).isPresent();
            if (!exists) {
                this.getLogger().warn("Resource [{}] for Region [{}] could not be found; skipping import for Region", (Object)resourceLocation, (Object)region.getFullPath());
            } else {
                Assert.state((boolean)readable, () -> String.format("Resource [%1$s] for Region [%2$s] is not readable", resourceLocation, region.getFullPath()));
            }
            return resource;
        }

        @Override
        @Nullable
        protected Resource onMissingResource(@Nullable Resource resource, @NonNull String location) {
            this.getLogger().warn("Resource [{}] at location [{}] does not exist; skipping import", (Object)ResourceUtils.nullSafeGetDescription(resource), (Object)location);
            return null;
        }
    }

    @FunctionalInterface
    public static interface ImportResourceResolver
    extends CacheResourceResolver {
    }

    public static class FileSystemExportResourceResolver
    extends AbstractExportResourceResolver {
        @Override
        @NonNull
        protected String getResourcePath() {
            return String.format("%1$s%2$s%3$s", ResourcePrefix.FILESYSTEM_URL_PREFIX.toUrlPrefix(), System.getProperty("user.dir"), File.separator);
        }
    }

    public static abstract class AbstractExportResourceResolver
    extends AbstractCacheResourceResolver
    implements ExportResourceResolver {
        @Override
        public Optional<Resource> resolve(@NonNull Region<?, ?> region) {
            Assert.notNull(region, (String)"Region must not be null");
            String resourceLocation = this.getResourceLocation(region, ResourceCapableCacheDataImporterExporter.CACHE_DATA_EXPORT_RESOURCE_LOCATION_PROPERTY_NAME);
            Optional<Resource> resource = this.resolve(resourceLocation);
            boolean writable = resource.filter(ResourceUtils::isWritable).isPresent();
            if (!writable) {
                this.getLogger().warn("Resource [{}] for Region [{}] is not writable", (Object)resourceLocation, (Object)region.getFullPath());
            }
            return resource;
        }

        @Override
        @Nullable
        protected Resource onMissingResource(@Nullable Resource resource, @NonNull String location) {
            this.getLogger().warn("Resource [{}] at location [{}] does not exist; will try to create it on export", (Object)ResourceUtils.nullSafeGetDescription(resource), (Object)location);
            return resource;
        }
    }

    @FunctionalInterface
    public static interface ExportResourceResolver
    extends CacheResourceResolver {
    }

    protected static abstract class AbstractCacheResourceResolver
    extends ResourceLoaderResourceResolver
    implements ApplicationContextAware,
    CacheResourceResolver,
    EnvironmentAware {
        private ApplicationContext applicationContext;
        private Environment environment;
        private final ExpressionParser expressionParser;
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Map<String, Expression> compiledExpressions;
        private final SimpleEvaluationContext.Builder evaluationContextBuilder;

        public AbstractCacheResourceResolver() {
            this.expressionParser = this.newExpressionParser();
            this.evaluationContextBuilder = this.newEvaluationContextBuilder();
            this.compiledExpressions = new ConcurrentHashMap<String, Expression>();
        }

        private ExpressionParser newExpressionParser() {
            ClassLoader classLoader = this.getApplicationContext().map(ResourceLoader::getClassLoader).orElseGet(ClassUtils::getDefaultClassLoader);
            return new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, classLoader));
        }

        private SimpleEvaluationContext.Builder newEvaluationContextBuilder() {
            PropertyAccessor[] propertyAccessors = new PropertyAccessor[]{new BeanFactoryAccessor(), DataBindingPropertyAccessor.forReadOnlyAccess(), SmartEnvironmentAccessor.create()};
            SimpleEvaluationContext.Builder builder = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])propertyAccessors).withInstanceMethods();
            String conversionServiceBeanName = "conversionService";
            return this.getApplicationContext().filter(applicationContext -> applicationContext.containsBean(conversionServiceBeanName)).map(applicationContext -> (ConversionService)applicationContext.getBean(conversionServiceBeanName, ConversionService.class)).map(arg_0 -> ((SimpleEvaluationContext.Builder)builder).withConversionService(arg_0)).orElse(builder);
        }

        @NonNull
        protected EvaluationContext newEvaluationContext() {
            return this.evaluationContextBuilder.build();
        }

        public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        protected Optional<ApplicationContext> getApplicationContext() {
            return Optional.ofNullable(this.applicationContext);
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        protected Optional<Environment> getEnvironment() {
            return Optional.ofNullable(this.environment);
        }

        @NonNull
        protected ExpressionParser getExpressionParser() {
            return this.expressionParser;
        }

        protected Logger getLogger() {
            return this.logger;
        }

        @NonNull
        protected ParserContext getParserContext() {
            return ParserContext.TEMPLATE_EXPRESSION;
        }

        @Override
        protected boolean isQualified(@Nullable Resource resource) {
            return super.isQualified(resource) && resource.exists();
        }

        @NonNull
        protected String getFullyQualifiedResourceLocation(@NonNull Region<?, ?> region) {
            return String.format("%1$s%2$s", this.getResourcePath(), this.getResourceName(region));
        }

        @NonNull
        protected String getResourceLocation(@NonNull Region<?, ?> region, @NonNull String propertyName) {
            Assert.notNull(region, (String)"Region must not be null");
            Assert.hasText((String)propertyName, () -> String.format("Property name [%s] must be specified", propertyName));
            return this.getEnvironment().filter(environment -> environment.containsProperty(propertyName)).map(environment -> environment.getProperty(propertyName)).filter(StringUtils::hasText).map(resourceLocation -> this.evaluate((String)resourceLocation, region)).orElseGet(() -> this.getFullyQualifiedResourceLocation(region));
        }

        @Nullable
        protected String evaluate(@NonNull String expressionString, @NonNull Region<?, ?> region) {
            EvaluationContext evaluationContext = this.newEvaluationContext();
            evaluationContext.setVariable("regionName", (Object)region.getName().toLowerCase());
            this.getEnvironment().ifPresent(environment -> evaluationContext.setVariable("env", (Object)EnvironmentMapAdapter.from(environment)));
            Expression expression = this.parse(expressionString);
            Object value = this.getApplicationContext().map(applicationContext -> expression.getValue(evaluationContext, applicationContext)).orElseGet(() -> expression.getValue(evaluationContext));
            return value != null ? value.toString() : null;
        }

        protected Expression parse(String expressionString) {
            return this.compiledExpressions.computeIfAbsent(expressionString, it -> this.getExpressionParser().parseExpression(it, this.getParserContext()));
        }

        @NonNull
        protected String getResourceName(@NonNull Region<?, ?> region) {
            return this.getResourceName(region.getName().toLowerCase());
        }

        @NonNull
        protected String getResourceName(@NonNull String name) {
            return String.format(ResourceCapableCacheDataImporterExporter.RESOURCE_NAME_PATTERN, name);
        }

        @NonNull
        protected abstract String getResourcePath();
    }

    @FunctionalInterface
    protected static interface CacheResourceResolver
    extends ResourceResolver {
        public Optional<Resource> resolve(@NonNull Region<?, ?> var1);

        @Override
        default public Optional<Resource> resolve(@NonNull String location) {
            return Optional.empty();
        }
    }
}

