/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.repository.CrudRepository;
import org.springframework.geode.cache.RepositoryAsyncEventListener;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AsyncInlineCachingRegionConfigurer<T, ID>
implements RegionConfigurer {
    protected static final Predicate<String> DEFAULT_REGION_BEAN_NAME_PREDICATE = beanName -> false;
    private RepositoryAsyncEventListener.AsyncEventErrorHandler asyncEventErrorHandler;
    private Boolean batchConflationEnabled;
    private Boolean diskSynchronous;
    private Boolean forwardExpirationDestroy;
    private Boolean parallel;
    private Boolean persistent;
    private Boolean pauseEventDispatching;
    private final CrudRepository<T, ID> repository;
    private Function<AsyncEventListener, AsyncEventListener> asyncEventListenerPostProcessor;
    private Function<AsyncEventQueue, AsyncEventQueue> asyncEventQueuePostProcessor;
    private Function<AsyncEventQueueFactory, AsyncEventQueueFactory> asyncEventQueueFactoryPostProcessor;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private GatewayEventSubstitutionFilter gatewayEventSubstitutionFilter;
    private GatewaySender.OrderPolicy orderPolicy;
    private List<GatewayEventFilter> gatewayEventFilters;
    private final Predicate<String> regionBeanName;
    private String diskStoreName;

    public static <T, ID> AsyncInlineCachingRegionConfigurer<T, ID> create(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        return new AsyncInlineCachingRegionConfigurer<T, ID>(repository, regionBeanName);
    }

    public static <T, ID> AsyncInlineCachingRegionConfigurer<T, ID> create(@NonNull CrudRepository<T, ID> repository, @Nullable String regionBeanName) {
        return AsyncInlineCachingRegionConfigurer.create(repository, Predicate.isEqual(regionBeanName));
    }

    public AsyncInlineCachingRegionConfigurer(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        Assert.notNull(repository, (String)"CrudRepository must not be null");
        this.repository = repository;
        this.regionBeanName = regionBeanName != null ? regionBeanName : DEFAULT_REGION_BEAN_NAME_PREDICATE;
    }

    @NonNull
    protected Predicate<String> getRegionBeanName() {
        return this.regionBeanName;
    }

    @NonNull
    protected CrudRepository<T, ID> getRepository() {
        return this.repository;
    }

    public void configure(String beanName, PeerRegionFactoryBean<?, ?> bean) {
        if (this.getRegionBeanName().test(beanName)) {
            AsyncEventQueue queue = this.newAsyncEventQueue((Cache)bean.getCache(), beanName);
            bean.addAsyncEventQueues((AsyncEventQueue[])ArrayUtils.asArray((Object[])new AsyncEventQueue[]{queue}));
        }
    }

    @NonNull
    protected String generateId(@NonNull String regionBeanName) {
        Assert.hasText((String)regionBeanName, () -> String.format("Region bean name [%s] must be specified", regionBeanName));
        return regionBeanName.concat(String.format("-AEQ-%s", UUID.randomUUID().toString()));
    }

    protected AsyncEventQueue newAsyncEventQueue(@NonNull Cache peerCache, @NonNull String regionBeanName) {
        AsyncEventQueueFactory asyncEventQueueFactory = this.newAsyncEventQueueFactory(peerCache);
        Optional.ofNullable(this.batchConflationEnabled).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setBatchConflationEnabled(arg_0));
        Optional.ofNullable(this.batchSize).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setBatchSize(arg_0));
        Optional.ofNullable(this.batchTimeInterval).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setBatchTimeInterval(arg_0));
        Optional.ofNullable(this.diskStoreName).filter(StringUtils::hasText).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setDiskStoreName(arg_0));
        Optional.ofNullable(this.diskSynchronous).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setDiskSynchronous(arg_0));
        Optional.ofNullable(this.dispatcherThreads).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setDispatcherThreads(arg_0));
        Optional.ofNullable(this.forwardExpirationDestroy).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setForwardExpirationDestroy(arg_0));
        Optional.ofNullable(this.gatewayEventSubstitutionFilter).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setGatewayEventSubstitutionListener(arg_0));
        Optional.ofNullable(this.maximumQueueMemory).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setMaximumQueueMemory(arg_0));
        Optional.ofNullable(this.orderPolicy).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setOrderPolicy(arg_0));
        Optional.ofNullable(this.parallel).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setParallel(arg_0));
        Optional.ofNullable(this.persistent).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setPersistent(arg_0));
        CollectionUtils.nullSafeList(this.gatewayEventFilters).stream().filter(Objects::nonNull).forEach(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).addGatewayEventFilter(arg_0));
        if (Boolean.TRUE.equals(this.pauseEventDispatching)) {
            asyncEventQueueFactory.pauseEventDispatching();
        }
        String asyncEventQueueId = this.generateId(regionBeanName);
        AsyncEventListener asyncEventListener = this.newRepositoryAsyncEventListener();
        asyncEventListener = this.postProcess(asyncEventListener);
        asyncEventQueueFactory = this.postProcess(asyncEventQueueFactory);
        AsyncEventQueue asyncEventQueue = this.newAsyncEventQueue(asyncEventQueueFactory, asyncEventQueueId, asyncEventListener);
        asyncEventQueue = this.postProcess(asyncEventQueue);
        return asyncEventQueue;
    }

    @NonNull
    protected AsyncEventQueue newAsyncEventQueue(@NonNull AsyncEventQueueFactory factory, @NonNull String asyncEventQueueId, @NonNull AsyncEventListener listener) {
        return factory.create(asyncEventQueueId, listener);
    }

    @NonNull
    protected AsyncEventQueueFactory newAsyncEventQueueFactory(@NonNull Cache peerCache) {
        return peerCache.createAsyncEventQueueFactory();
    }

    @NonNull
    protected AsyncEventListener newRepositoryAsyncEventListener() {
        return this.newRepositoryAsyncEventListener(this.getRepository());
    }

    @NonNull
    protected AsyncEventListener newRepositoryAsyncEventListener(@NonNull CrudRepository<T, ID> repository) {
        return new RepositoryAsyncEventListener<T, ID>(repository);
    }

    @NonNull
    protected AsyncEventListener postProcess(@NonNull AsyncEventListener asyncEventListener) {
        return this.resolveAsyncEventListenerPostProcessor().apply(asyncEventListener);
    }

    @NonNull
    protected AsyncEventQueue postProcess(@NonNull AsyncEventQueue asyncEventQueue) {
        Function<AsyncEventQueue, AsyncEventQueue> asyncEventQueuePostProcessor = this.asyncEventQueuePostProcessor;
        return asyncEventQueuePostProcessor != null ? asyncEventQueuePostProcessor.apply(asyncEventQueue) : asyncEventQueue;
    }

    @NonNull
    protected AsyncEventQueueFactory postProcess(@NonNull AsyncEventQueueFactory asyncEventQueueFactory) {
        Function<AsyncEventQueueFactory, AsyncEventQueueFactory> asyncEventQueueFactoryPostProcessor = this.asyncEventQueueFactoryPostProcessor;
        return asyncEventQueueFactoryPostProcessor != null ? asyncEventQueueFactoryPostProcessor.apply(asyncEventQueueFactory) : asyncEventQueueFactory;
    }

    @NonNull
    private Function<AsyncEventListener, AsyncEventListener> resolveAsyncEventListenerPostProcessor() {
        RepositoryAsyncEventListener.AsyncEventErrorHandler asyncEventErrorHandler = this.asyncEventErrorHandler;
        Function<AsyncEventListener, AsyncEventListener> resolvedListenerPostProcessor = asyncEventErrorHandler != null ? listener -> {
            if (listener instanceof RepositoryAsyncEventListener) {
                ((RepositoryAsyncEventListener)listener).setAsyncEventErrorHandler(asyncEventErrorHandler);
            }
            return listener;
        } : Function.identity();
        Function<AsyncEventListener, AsyncEventListener> asyncEventListenerPostProcessor = this.asyncEventListenerPostProcessor;
        if (asyncEventListenerPostProcessor != null) {
            resolvedListenerPostProcessor = resolvedListenerPostProcessor.andThen(asyncEventListenerPostProcessor);
        }
        return resolvedListenerPostProcessor;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> applyToListener(@Nullable Function<AsyncEventListener, AsyncEventListener> asyncEventListenerPostProcessor) {
        this.asyncEventListenerPostProcessor = asyncEventListenerPostProcessor;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> applyToQueue(@Nullable Function<AsyncEventQueue, AsyncEventQueue> asyncEventQueuePostProcessor) {
        this.asyncEventQueuePostProcessor = asyncEventQueuePostProcessor;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> applyToQueueFactory(@Nullable Function<AsyncEventQueueFactory, AsyncEventQueueFactory> asyncEventQueueFactoryPostProcessor) {
        this.asyncEventQueueFactoryPostProcessor = asyncEventQueueFactoryPostProcessor;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withAsyncEventErrorHandler(@Nullable RepositoryAsyncEventListener.AsyncEventErrorHandler errorHandler) {
        this.asyncEventErrorHandler = errorHandler;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withParallelQueue() {
        this.parallel = true;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withPersistentQueue() {
        this.persistent = true;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueBatchConflationEnabled() {
        this.batchConflationEnabled = true;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueBatchTimeInterval(Duration batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval != null ? Integer.valueOf(Long.valueOf(batchTimeInterval.toMillis()).intValue()) : null;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueDiskStore(String diskStoreName) {
        this.diskStoreName = diskStoreName;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueDiskSynchronizationEnabled() {
        this.diskSynchronous = true;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueDispatcherThreadCount(int dispatcherThreadCount) {
        this.dispatcherThreads = dispatcherThreadCount;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueEventDispatchingPaused() {
        this.pauseEventDispatching = true;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueEventFilters(List<GatewayEventFilter> eventFilters) {
        this.gatewayEventFilters = eventFilters;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueEventSubstitutionFilter(@Nullable GatewayEventSubstitutionFilter<ID, T> eventSubstitutionFilter) {
        this.gatewayEventSubstitutionFilter = eventSubstitutionFilter;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueForwardedExpirationDestroyEvents() {
        this.forwardExpirationDestroy = true;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueMaxMemory(int maximumMemory) {
        this.maximumQueueMemory = maximumMemory;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withQueueOrderPolicy(@Nullable GatewaySender.OrderPolicy orderPolicy) {
        this.orderPolicy = orderPolicy;
        return this;
    }

    public AsyncInlineCachingRegionConfigurer<T, ID> withSerialQueue() {
        this.parallel = false;
        return this;
    }
}

