/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.io.IOException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DigestUtils;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptingException;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;

public class DefaultRedisScript<T>
implements RedisScript<T>,
InitializingBean {
    private ScriptSource scriptSource;
    private String sha1;
    private Class<T> resultType;
    private final Object shaModifiedMonitor = new Object();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.scriptSource, (String)"Either script, script location, or script source is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSha1() {
        Object object = this.shaModifiedMonitor;
        synchronized (object) {
            if (this.sha1 == null || this.scriptSource.isModified()) {
                this.sha1 = DigestUtils.sha1DigestAsHex(this.getScriptAsString());
            }
            return this.sha1;
        }
    }

    @Override
    public Class<T> getResultType() {
        return this.resultType;
    }

    @Override
    public String getScriptAsString() {
        try {
            return this.scriptSource.getScriptAsString();
        }
        catch (IOException e) {
            throw new ScriptingException("Error reading script text", e);
        }
    }

    public void setResultType(Class<T> resultType) {
        this.resultType = resultType;
    }

    public void setScriptText(String scriptText) {
        this.scriptSource = new StaticScriptSource(scriptText);
    }

    public void setLocation(Resource scriptLocation) {
        this.scriptSource = new ResourceScriptSource(scriptLocation);
    }

    public void setScriptSource(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }
}

