/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.util.Assert;

public class RedisSentinelConfiguration {
    private NamedNode master;
    private Set<RedisNode> sentinels = new LinkedHashSet<RedisNode>();

    public void setSentinels(Iterable<RedisNode> sentinels) {
        Assert.notNull(sentinels, (String)"Cannot set sentinels to 'null'.");
        this.sentinels.clear();
        for (RedisNode sentinel : sentinels) {
            this.addSentinel(sentinel);
        }
    }

    public Set<RedisNode> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void addSentinel(RedisNode sentinel) {
        Assert.notNull((Object)sentinel, (String)"Sentinel must not be 'null'.");
        this.sentinels.add(sentinel);
    }

    public void setMaster(final String name) {
        Assert.notNull((Object)name, (String)"Name of sentinel master must not be null.");
        this.setMaster(new NamedNode(){

            @Override
            public String getName() {
                return name;
            }
        });
    }

    public void setMaster(NamedNode master) {
        Assert.notNull((Object)"Sentinel master node must not be 'null'.");
        this.master = master;
    }

    public NamedNode getMaster() {
        return this.master;
    }

    public RedisSentinelConfiguration master(String master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration master(NamedNode master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration sentinel(RedisNode sentinel) {
        this.addSentinel(sentinel);
        return this;
    }

    public RedisSentinelConfiguration sentinel(String host, Integer port) {
        return this.sentinel(new RedisNode(host, port));
    }
}

