/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.Collection;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.ShardKey;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;

public interface MongoPersistentEntity<T>
extends MutablePersistentEntity<T, MongoPersistentProperty> {
    public String getCollection();

    public String getLanguage();

    @Nullable
    public MongoPersistentProperty getTextScoreProperty();

    public boolean hasTextScoreProperty();

    @Nullable
    public Collation getCollation();

    default public boolean hasCollation() {
        return this.getCollation() != null;
    }

    public ShardKey getShardKey();

    default public boolean isSharded() {
        return this.getShardKey().isSharded();
    }

    default public boolean isUnwrapped() {
        return false;
    }

    @Nullable
    public Collection<Object> getEncryptionKeyIds();
}

