/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.bson.BSONObject;
import org.bson.types.BasicBSONList;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.geo.Circle;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.geo.Shape;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criteria
implements CriteriaDefinition {
    private static final Object NOT_SET = new Object();
    private String key;
    private List<Criteria> criteriaChain;
    private LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    private Object isValue = NOT_SET;

    public Criteria() {
        this.criteriaChain = new ArrayList<Criteria>();
    }

    public Criteria(String key) {
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = key;
    }

    protected Criteria(List<Criteria> criteriaChain, String key) {
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = key;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria is(Object o) {
        if (this.isValue != NOT_SET) {
            throw new InvalidMongoDbApiUsageException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.criteria.size() > 0 && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1])) {
            throw new InvalidMongoDbApiUsageException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        this.isValue = o;
        return this;
    }

    public Criteria ne(Object o) {
        this.criteria.put("$ne", o);
        return this;
    }

    public Criteria lt(Object o) {
        this.criteria.put("$lt", o);
        return this;
    }

    public Criteria lte(Object o) {
        this.criteria.put("$lte", o);
        return this;
    }

    public Criteria gt(Object o) {
        this.criteria.put("$gt", o);
        return this;
    }

    public Criteria gte(Object o) {
        this.criteria.put("$gte", o);
        return this;
    }

    public Criteria in(Object ... o) {
        if (o.length > 1 && o[1] instanceof Collection) {
            throw new InvalidMongoDbApiUsageException("You can only pass in one argument of type " + o[1].getClass().getName());
        }
        this.criteria.put("$in", Arrays.asList(o));
        return this;
    }

    public Criteria in(Collection<?> c) {
        this.criteria.put("$in", c);
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> o) {
        this.criteria.put("$nin", o);
        return this;
    }

    public Criteria mod(Number value, Number remainder) {
        ArrayList<Number> l = new ArrayList<Number>();
        l.add(value);
        l.add(remainder);
        this.criteria.put("$mod", l);
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> o) {
        this.criteria.put("$all", o);
        return this;
    }

    public Criteria size(int s) {
        this.criteria.put("$size", s);
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteria.put("$exists", b);
        return this;
    }

    public Criteria type(int t) {
        this.criteria.put("$type", t);
        return this;
    }

    public Criteria not() {
        this.criteria.put("$not", null);
        return this;
    }

    public Criteria regex(String re) {
        this.criteria.put("$regex", re);
        return this;
    }

    public Criteria regex(String re, String options) {
        this.criteria.put("$regex", re);
        if (StringUtils.hasText((String)options)) {
            this.criteria.put("$options", options);
        }
        return this;
    }

    public Criteria withinSphere(Circle circle) {
        Assert.notNull((Object)circle);
        this.criteria.put("$within", new BasicDBObject("$centerSphere", circle.asList()));
        return this;
    }

    public Criteria within(Shape shape) {
        Assert.notNull((Object)shape);
        this.criteria.put("$within", new BasicDBObject(shape.getCommand(), shape.asList()));
        return this;
    }

    public Criteria near(Point point) {
        Assert.notNull((Object)point);
        this.criteria.put("$near", point.asList());
        return this;
    }

    public Criteria nearSphere(Point point) {
        Assert.notNull((Object)point);
        this.criteria.put("$nearSphere", point.asList());
        return this;
    }

    public Criteria maxDistance(double maxDistance) {
        this.criteria.put("$maxDistance", maxDistance);
        return this;
    }

    public Criteria elemMatch(Criteria c) {
        this.criteria.put("$elemMatch", c.getCriteriaObject());
        return this;
    }

    public Criteria orOperator(Criteria ... criteria) {
        BasicBSONList bsonList = this.createCriteriaList(criteria);
        this.criteriaChain.add(new Criteria("$or").is(bsonList));
        return this;
    }

    public Criteria norOperator(Criteria ... criteria) {
        BasicBSONList bsonList = this.createCriteriaList(criteria);
        this.criteriaChain.add(new Criteria("$nor").is(bsonList));
        return this;
    }

    public Criteria andOperator(Criteria ... criteria) {
        BasicBSONList bsonList = this.createCriteriaList(criteria);
        this.criteriaChain.add(new Criteria("$and").is(bsonList));
        return this;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public DBObject getCriteriaObject() {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).getSingleCriteriaObject();
        }
        BasicDBObject criteriaObject = new BasicDBObject();
        for (Criteria c : this.criteriaChain) {
            DBObject dbo = c.getSingleCriteriaObject();
            for (String k : dbo.keySet()) {
                this.setValue((DBObject)criteriaObject, k, dbo.get(k));
            }
        }
        return criteriaObject;
    }

    protected DBObject getSingleCriteriaObject() {
        BasicDBObject dbo = new BasicDBObject();
        boolean not = false;
        for (String k : this.criteria.keySet()) {
            if (not) {
                BasicDBObject notDbo = new BasicDBObject();
                notDbo.put(k, this.criteria.get(k));
                dbo.put("$not", (Object)notDbo);
                not = false;
                continue;
            }
            if ("$not".equals(k)) {
                not = true;
                continue;
            }
            dbo.put(k, this.criteria.get(k));
        }
        BasicDBObject queryCriteria = new BasicDBObject();
        if (this.isValue != NOT_SET) {
            queryCriteria.put(this.key, this.isValue);
            queryCriteria.putAll((BSONObject)dbo);
        } else {
            queryCriteria.put(this.key, (Object)dbo);
        }
        return queryCriteria;
    }

    private BasicBSONList createCriteriaList(Criteria[] criteria) {
        BasicBSONList bsonList = new BasicBSONList();
        for (Criteria c : criteria) {
            bsonList.add((Object)c.getCriteriaObject());
        }
        return bsonList;
    }

    private void setValue(DBObject dbo, String key, Object value) {
        Object existing = dbo.get(key);
        if (existing != null) {
            throw new InvalidMongoDbApiUsageException("Due to limitations of the com.mongodb.BasicDBObject, you can't add a second '" + key + "' expression specified as '" + key + " : " + value + "'. " + "Criteria already contains '" + key + " : " + existing + "'.");
        }
        dbo.put(key, value);
    }
}

