/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.mapreduce.MapReduceCounts;
import org.springframework.data.mongodb.core.mapreduce.MapReduceTiming;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private DBObject rawResults;
    private MapReduceTiming mapReduceTiming;
    private MapReduceCounts mapReduceCounts;
    private String outputCollection;

    public MapReduceResults(List<T> mappedResults, DBObject rawResults) {
        Assert.notNull(mappedResults);
        Assert.notNull((Object)rawResults);
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.parseTiming(rawResults);
        this.parseCounts(rawResults);
        if (rawResults.get("result") != null) {
            this.outputCollection = (String)rawResults.get("result");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public MapReduceTiming getTiming() {
        return this.mapReduceTiming;
    }

    public MapReduceCounts getCounts() {
        return this.mapReduceCounts;
    }

    public String getOutputCollection() {
        return this.outputCollection;
    }

    public DBObject getRawResults() {
        return this.rawResults;
    }

    protected void parseTiming(DBObject rawResults) {
        DBObject timing = (DBObject)rawResults.get("timing");
        if (timing != null) {
            if (timing.get("mapTime") != null && timing.get("emitLoop") != null && timing.get("total") != null) {
                this.mapReduceTiming = new MapReduceTiming((Long)timing.get("mapTime"), ((Integer)timing.get("emitLoop")).intValue(), ((Integer)timing.get("total")).intValue());
            }
        } else {
            this.mapReduceTiming = new MapReduceTiming(-1L, -1L, -1L);
        }
    }

    protected void parseCounts(DBObject rawResults) {
        DBObject counts = (DBObject)rawResults.get("counts");
        if (counts != null) {
            if (counts.get("input") != null && counts.get("emit") != null && counts.get("output") != null) {
                this.mapReduceCounts = new MapReduceCounts((Integer)counts.get("input"), (Integer)counts.get("emit"), (Integer)counts.get("output"));
            }
        } else {
            this.mapReduceCounts = new MapReduceCounts(-1, -1, -1);
        }
    }
}

