/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoURI;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoDbUtils;
import org.springframework.util.Assert;

public class SimpleMongoDbFactory
implements DisposableBean,
MongoDbFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Mongo mongo;
    private final String databaseName;
    private String username;
    private String password;
    private WriteConcern writeConcern;

    public SimpleMongoDbFactory(Mongo mongo, String databaseName) {
        Assert.notNull((Object)mongo, (String)"Mongo must not be null");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty");
        Assert.isTrue((boolean)databaseName.matches("[\\w-]+"), (String)"Database name must only contain letters, numbers, underscores and dashes!");
        this.mongo = mongo;
        this.databaseName = databaseName;
    }

    public SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials userCredentials) {
        this(mongo, databaseName);
        this.username = userCredentials.getUsername();
        this.password = userCredentials.getPassword();
    }

    public SimpleMongoDbFactory(MongoURI uri) throws MongoException, UnknownHostException {
        this(new Mongo(uri), uri.getDatabase(), new UserCredentials(uri.getUsername(), SimpleMongoDbFactory.parseChars(uri.getPassword())));
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public DB getDb() throws DataAccessException {
        return this.getDb(this.databaseName);
    }

    public DB getDb(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty.");
        DB db = MongoDbUtils.getDB(this.mongo, dbName, this.username, this.password == null ? null : this.password.toCharArray());
        if (this.writeConcern != null) {
            db.setWriteConcern(this.writeConcern);
        }
        return db;
    }

    public void destroy() throws Exception {
        this.mongo.close();
    }

    public static String parseChars(char[] chars) {
        if (chars == null) {
            return null;
        }
        return String.valueOf(chars);
    }
}

