/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.IndexOptions;
import org.springframework.data.elasticsearch.annotations.IndexPrefixes;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.NullValueType;
import org.springframework.data.elasticsearch.annotations.Similarity;
import org.springframework.data.elasticsearch.annotations.TermVector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class MappingParameters {
    static final String FIELD_PARAM_COERCE = "coerce";
    static final String FIELD_PARAM_COPY_TO = "copy_to";
    static final String FIELD_PARAM_DATA = "fielddata";
    static final String FIELD_PARAM_DOC_VALUES = "doc_values";
    static final String FIELD_PARAM_EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";
    static final String FIELD_PARAM_ENABLED = "enabled";
    static final String FIELD_PARAM_FORMAT = "format";
    static final String FIELD_PARAM_IGNORE_ABOVE = "ignore_above";
    static final String FIELD_PARAM_IGNORE_MALFORMED = "ignore_malformed";
    static final String FIELD_PARAM_IGNORE_Z_VALUE = "ignore_z_value";
    static final String FIELD_PARAM_INDEX = "index";
    static final String FIELD_PARAM_INDEX_OPTIONS = "index_options";
    static final String FIELD_PARAM_INDEX_PHRASES = "index_phrases";
    static final String FIELD_PARAM_INDEX_PREFIXES = "index_prefixes";
    static final String FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS = "min_chars";
    static final String FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS = "max_chars";
    static final String FIELD_PARAM_INDEX_ANALYZER = "analyzer";
    static final String FIELD_PARAM_MAX_SHINGLE_SIZE = "max_shingle_size";
    static final String FIELD_PARAM_NORMALIZER = "normalizer";
    static final String FIELD_PARAM_NORMS = "norms";
    static final String FIELD_PARAM_NULL_VALUE = "null_value";
    static final String FIELD_PARAM_POSITION_INCREMENT_GAP = "position_increment_gap";
    static final String FIELD_PARAM_ORIENTATION = "orientation";
    static final String FIELD_PARAM_POSITIVE_SCORE_IMPACT = "positive_score_impact";
    static final String FIELD_PARAM_DIMS = "dims";
    static final String FIELD_PARAM_SCALING_FACTOR = "scaling_factor";
    static final String FIELD_PARAM_SEARCH_ANALYZER = "search_analyzer";
    static final String FIELD_PARAM_STORE = "store";
    static final String FIELD_PARAM_SIMILARITY = "similarity";
    static final String FIELD_PARAM_TERM_VECTOR = "term_vector";
    static final String FIELD_PARAM_TYPE = "type";
    private final String analyzer;
    private final boolean coerce;
    @Nullable
    private final String[] copyTo;
    private final DateFormat[] dateFormats;
    private final String[] dateFormatPatterns;
    private final boolean docValues;
    private final boolean eagerGlobalOrdinals;
    private final boolean enabled;
    private final boolean fielddata;
    @Nullable
    private final Integer ignoreAbove;
    private final boolean ignoreMalformed;
    private final boolean index;
    private final IndexOptions indexOptions;
    private final boolean indexPhrases;
    @Nullable
    private final IndexPrefixes indexPrefixes;
    private final String normalizer;
    private final boolean norms;
    @Nullable
    private final Integer maxShingleSize;
    private final String nullValue;
    private final NullValueType nullValueType;
    private final Integer positionIncrementGap;
    private final boolean positiveScoreImpact;
    private final Integer dims;
    private final String searchAnalyzer;
    private final double scalingFactor;
    private final Similarity similarity;
    private final boolean store;
    private final TermVector termVector;
    private final FieldType type;

    public static MappingParameters from(Annotation annotation) {
        Assert.notNull((Object)annotation, (String)"annotation must not be null!");
        if (annotation instanceof Field) {
            return new MappingParameters((Field)annotation);
        }
        if (annotation instanceof InnerField) {
            return new MappingParameters((InnerField)annotation);
        }
        throw new IllegalArgumentException("annotation must be an instance of @Field or @InnerField");
    }

    private MappingParameters(Field field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.dateFormats = field.format();
        this.dateFormatPatterns = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = field.copyTo();
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        this.indexPrefixes = field.indexPrefixes().length > 0 ? field.indexPrefixes()[0] : null;
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.nullValueType = field.nullValueType();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
        this.positiveScoreImpact = field.positiveScoreImpact();
        this.dims = field.dims();
        if (this.type == FieldType.Dense_Vector) {
            Assert.isTrue((this.dims >= 1 && this.dims <= 2048 ? 1 : 0) != 0, (String)"Invalid required parameter! Dense_Vector value \"dims\" must be between 1 and 2048.");
        }
        Assert.isTrue((field.enabled() || this.type == FieldType.Object ? 1 : 0) != 0, (String)"enabled false is only allowed for field type object");
        this.enabled = field.enabled();
        this.eagerGlobalOrdinals = field.eagerGlobalOrdinals();
    }

    private MappingParameters(InnerField field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.dateFormats = field.format();
        this.dateFormatPatterns = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = null;
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        this.indexPrefixes = field.indexPrefixes().length > 0 ? field.indexPrefixes()[0] : null;
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.nullValueType = field.nullValueType();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
        this.positiveScoreImpact = field.positiveScoreImpact();
        this.dims = field.dims();
        if (this.type == FieldType.Dense_Vector) {
            Assert.isTrue((this.dims >= 1 && this.dims <= 2048 ? 1 : 0) != 0, (String)"Invalid required parameter! Dense_Vector value \"dims\" must be between 1 and 2048.");
        }
        this.enabled = true;
        this.eagerGlobalOrdinals = field.eagerGlobalOrdinals();
    }

    public boolean isStore() {
        return this.store;
    }

    public void writeTypeAndParametersTo(ObjectNode objectNode) throws IOException {
        Assert.notNull((Object)objectNode, (String)"objectNode must not be null");
        if (this.fielddata) {
            objectNode.put(FIELD_PARAM_DATA, this.fielddata);
        }
        if (this.type != FieldType.Auto) {
            objectNode.put(FIELD_PARAM_TYPE, this.type.getMappedName());
            if (this.type == FieldType.Date || this.type == FieldType.Date_Nanos || this.type == FieldType.Date_Range) {
                ArrayList<String> formats = new ArrayList<String>();
                for (DateFormat dateFormat : this.dateFormats) {
                    if (dateFormat == DateFormat.none || dateFormat == DateFormat.custom) continue;
                    formats.add(dateFormat.toString());
                }
                Collections.addAll(formats, this.dateFormatPatterns);
                if (!formats.isEmpty()) {
                    objectNode.put(FIELD_PARAM_FORMAT, String.join((CharSequence)"||", formats));
                }
            }
        }
        if (!this.index) {
            objectNode.put(FIELD_PARAM_INDEX, this.index);
        }
        if (StringUtils.hasLength((String)this.analyzer)) {
            objectNode.put(FIELD_PARAM_INDEX_ANALYZER, this.analyzer);
        }
        if (StringUtils.hasLength((String)this.searchAnalyzer)) {
            objectNode.put(FIELD_PARAM_SEARCH_ANALYZER, this.searchAnalyzer);
        }
        if (StringUtils.hasLength((String)this.normalizer)) {
            objectNode.put(FIELD_PARAM_NORMALIZER, this.normalizer);
        }
        if (this.copyTo != null && this.copyTo.length > 0) {
            objectNode.putArray(FIELD_PARAM_COPY_TO).addAll((Collection)Arrays.stream(this.copyTo).map(TextNode::valueOf).collect(Collectors.toList()));
        }
        if (this.ignoreAbove != null) {
            Assert.isTrue((this.ignoreAbove >= 0 ? 1 : 0) != 0, (String)"ignore_above must be a positive value");
            objectNode.put(FIELD_PARAM_IGNORE_ABOVE, this.ignoreAbove);
        }
        if (!this.coerce) {
            objectNode.put(FIELD_PARAM_COERCE, this.coerce);
        }
        if (!this.docValues) {
            objectNode.put(FIELD_PARAM_DOC_VALUES, this.docValues);
        }
        if (this.ignoreMalformed) {
            objectNode.put(FIELD_PARAM_IGNORE_MALFORMED, this.ignoreMalformed);
        }
        if (this.indexOptions != IndexOptions.none) {
            objectNode.put(FIELD_PARAM_INDEX_OPTIONS, this.indexOptions.toString());
        }
        if (this.indexPhrases) {
            objectNode.put(FIELD_PARAM_INDEX_PHRASES, this.indexPhrases);
        }
        if (this.indexPrefixes != null) {
            ObjectNode prefixNode = objectNode.putObject(FIELD_PARAM_INDEX_PREFIXES);
            if (this.indexPrefixes.minChars() != 2) {
                prefixNode.put(FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS, this.indexPrefixes.minChars());
            }
            if (this.indexPrefixes.maxChars() != 2) {
                prefixNode.put(FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS, this.indexPrefixes.maxChars());
            }
        }
        if (!this.norms) {
            objectNode.put(FIELD_PARAM_NORMS, this.norms);
        }
        if (StringUtils.hasLength((String)this.nullValue)) {
            switch (this.nullValueType) {
                case Integer: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, Integer.valueOf(this.nullValue));
                    break;
                }
                case Long: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, Long.valueOf(this.nullValue));
                    break;
                }
                case Double: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, Double.valueOf(this.nullValue));
                    break;
                }
                default: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, this.nullValue);
                }
            }
        }
        if (this.positionIncrementGap != null && this.positionIncrementGap >= 0) {
            objectNode.put(FIELD_PARAM_POSITION_INCREMENT_GAP, this.positionIncrementGap);
        }
        if (this.similarity != Similarity.Default) {
            objectNode.put(FIELD_PARAM_SIMILARITY, this.similarity.toString());
        }
        if (this.termVector != TermVector.none) {
            objectNode.put(FIELD_PARAM_TERM_VECTOR, this.termVector.toString());
        }
        if (this.type == FieldType.Scaled_Float) {
            objectNode.put(FIELD_PARAM_SCALING_FACTOR, this.scalingFactor);
        }
        if (this.maxShingleSize != null) {
            objectNode.put(FIELD_PARAM_MAX_SHINGLE_SIZE, this.maxShingleSize);
        }
        if (!this.positiveScoreImpact) {
            objectNode.put(FIELD_PARAM_POSITIVE_SCORE_IMPACT, this.positiveScoreImpact);
        }
        if (this.type == FieldType.Dense_Vector) {
            objectNode.put(FIELD_PARAM_DIMS, this.dims);
        }
        if (!this.enabled) {
            objectNode.put(FIELD_PARAM_ENABLED, this.enabled);
        }
        if (this.eagerGlobalOrdinals) {
            objectNode.put(FIELD_PARAM_EAGER_GLOBAL_ORDINALS, this.eagerGlobalOrdinals);
        }
    }
}

